//---------------------------------------------------------------------------
//
//	  y TAD viewer for Windows z
//    compatible display primitive
//    image library
//	  JJ,micropower,HigashiHiroshima City,1996,1997,1998,2000
//
//---------------------------------------------------------------------------
#include <stdlib.h>
#include <stdio.h> //for debug
//---------------------------------------------------------------------------
// bmp摜wb_TCYԂB
//---------------------------------------------------------------------------
inline int IBMP::get_bmp_header_size(void)
{
	return ( sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER) + sizeof(RGBQUAD) * colors );
}
//---------------------------------------------------------------------------
// bmp摜rbg}bṽTCYԂB
//---------------------------------------------------------------------------
inline int IBMP::get_bmp_size( int width, int height )
{
	return (( width * pixel_bytes + 3 ) / 4 ) * 4 * height;
}
//---------------------------------------------------------------------------
// width,heightTCY̓C[Wi摜j̑STCYԂB
//---------------------------------------------------------------------------
inline int IBMP::get_bmp_allSize( int width, int height )
{
//	return ( sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER) + sizeof(RGBQUAD) * colors + ((width + 31 ) / 32 ) * 32 * height * pixel_bytes );
	return ( sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER) + sizeof(RGBQUAD) * colors + get_bmp_size( width, height ) );
}
//---------------------------------------------------------------------------
// RXgN^
// rq=NULL̏ꍇ܂͂PUFAQTUFȊOAtJ[Ƃ݂ȂBicols͂OƂ݂Ȃj
//---------------------------------------------------------------------------
IBMP::IBMP( jBMP bmp, RGBQUAD *rq, int cols, jUB pxmsk )
{
	//logpal=NULL;
	//hpal=NULL;
	result=jEG_OK;
	if( bmp == NULL )
    {
    	result=jEG_ADR;
        return;
    }
    //1B 16F( color: 0x0009, compac : 0, cinfo[0] : 0)
    //3B 256F( color: 0x0009, compac : 0 )
    //ȊÔƂtJ[Ƃ݂ȂB
 	if( !( bmp->planes == 4 && ( bmp->pixbits & 0xFF00 ) == 0x0100 ) &&
    	!( bmp->planes == 1 && ( bmp->pixbits & 0xFF00 ) == 0x0800 ) )
    {
		rq=NULL;
    }
    if( rq == NULL )
    {
    	pixel_bytes=3;	//24 bits(3bytes) colors tJ[
    	colors=0;
    }
    else
    {
    	pixel_bytes=1;	//8 bits(1byte) colors QTUFJ[
    	colors=cols;
    }
    pixel_mask=pxmsk;
	Width=(int)( bmp->bounds.c.right - bmp->bounds.c.left );
    Height=(int)( bmp->bounds.c.bottom - bmp->bounds.c.top );
	bmp_rowbytes=(( Width * pixel_bytes + 3 ) / 4 ) * 4;	//4oCgP
    bmp_size=get_bmp_size( Width, Height );
    bm=new TMemoryStream;
    if( bm == NULL )
    {
    	result=jEG_NOSPC;
    	return;
    }
    bm->SetSize( get_bmp_allSize( Width, Height ) );
    if( bm->Size < get_bmp_allSize( Width, Height ) )
    {
    	result=jEG_NOSPC;
    	return;
    }
    if( rq != NULL ) set_rgb( rq );
    //make_palette( rq );
    if( !Convert( bmp ) )
    	result=jEG_NOSPT;
}
//---------------------------------------------------------------------------
// fXgN^
//---------------------------------------------------------------------------
IBMP::~IBMP()
{
	//if( logpal != NULL )	delete [] logpal;
	if( bm != NULL )	delete bm;
}
//---------------------------------------------------------------------------
// rbg}bvC[W̃Xg[ԂB
//---------------------------------------------------------------------------
//inline TMemoryStream* IBMP::Stream()
//{
//	return bm;
//}
//---------------------------------------------------------------------------
// bitsTCỸ}XNԂB
//---------------------------------------------------------------------------
int make_mask( int bits )
{
    int mask=0;
    for( int i=0 ; i < bits ; i++ )
    {
        int flag=1 << i;
        mask|=flag;
    }
    return mask;
}
//---------------------------------------------------------------------------
// RãC[W֕ϊ
//---------------------------------------------------------------------------
void IBMP::Convert3Bimage( jBMP bmp )
{
    int limit=0;
    if( Height != 0 )
    	limit=Height - 1;
	char *src=(char *)bmp->baseaddr[0];
	char *dst=(char *)( (char *)bm->Memory + get_bmp_header_size() );
    if( ( bmp->pixbits & 0xFF00 ) == 0x0800 )
    {
    	//ꍇɂđ召t]ij
	    int minBytes=min((int)bmp->rowbytes,(int)bmp_rowbytes);
        //QTUFPsNZPoCg
	    //aloW͉n܂̂ŃXLC㉺t]B
	    for( int i=0 ; i < Height ; i++ )
	    {
		    //src|C^dst|C^"minBytes"TCY]
		    memcpy( (char *)&dst[ (int)( bmp_rowbytes * ( limit - i )) ], (char *)&src[ (int)( bmp->rowbytes * i ) ], (size_t)minBytes );
	    } //end for i
    }
    else
    if( ( bmp->pixbits & 0xFF00 ) == 0x1000 )
    {
        //UTTRUFΉ
        //摜ZOg̒`ǂ܂Ȃ΂킩ȂBgdr_bmpɂ͓n炸Bǂ̂낤Hi^j
        //if( color != 0x0001 ) return;
        //int red_pos=(int)(( cinfo[ 0 ] >> 8 ) & 0x00FF );
        //int green_pos=(int)(cinfo[ 1 ] >> 8 ) & 0x00FF );
        //int blue_pos=(int)(cinfo[ 2 ] >> 8 ) & 0x00FF );
        //int red_bits=(int)(cinfo[ 0 ] & 0x00FF );
        //int green_bits=(int)(cinfo[ 1 ] & 0x00FF );
        //int blue_bits=(int)(cinfo[ 2 ] & 0x00FF );

        int red_pos=11;
        int green_pos=5;
        int blue_pos=0;
        int red_bits=5;
        int green_bits=6;
        int blue_bits=5;
        int red_mask=make_mask( red_bits );
        int green_mask=make_mask( green_bits );
        int blue_mask=make_mask( blue_bits );
        jUH *hsrc=(jUH *)bmp->baseaddr[0];
        for( int i=0 ; i < Height ; i++ )
        {
            for( int j=0 ; j < Width ; j++ )
            {
                //QoCgsNZl𓾂Ē`rbgtB[hɕAQTUKŐKB
                int pval=(int)( hsrc[ ( bmp->rowbytes * i + j * 2 )/2 ] );
                dst[ bmp_rowbytes * ( limit - i ) + j * 3     ]=(char)( ((( pval >> blue_pos ) & blue_mask ) * 255 ) / blue_mask );        //Blue
                dst[ bmp_rowbytes * ( limit - i ) + j * 3 + 1 ]=(char)( ((( pval >> green_pos ) & green_mask ) * 255 ) / green_mask );     //Green
                dst[ bmp_rowbytes * ( limit - i ) + j * 3 + 2 ]=(char)( ((( pval >> red_pos ) & red_mask ) * 255 ) / red_mask );           //Red
           }
        }
    }    else
    if( ( bmp->pixbits & 0xFF00 ) == 0x2000 )
    {
        //1677F
        for( int i=0 ; i < Height ; i++ )
        {
            for( int j=0 ; j < Width ; j++ )
            {
                dst[ bmp_rowbytes * ( limit - i ) + j * 3     ]=src[ bmp->rowbytes * i + j * 4     ];   //Blue
                dst[ bmp_rowbytes * ( limit - i ) + j * 3 + 1 ]=src[ bmp->rowbytes * i + j * 4 + 1 ];   //Green
                dst[ bmp_rowbytes * ( limit - i ) + j * 3 + 2 ]=src[ bmp->rowbytes * i + j * 4 + 2 ];   //Red
            }
        }
    }
}
//---------------------------------------------------------------------------
// pixelMasktłRãC[W֕ϊ
//---------------------------------------------------------------------------
void IBMP::Convert3Bimage( jBMP bmp, const jUB &pixelMask )
{

    int limit=0;
    if( Height != 0 )
    	limit=Height - 1;
	char *src=(char *)bmp->baseaddr[0];
	char *dst=(char *)( (char *)bm->Memory + get_bmp_header_size() );
    if( ( bmp->pixbits & 0xFF00 ) == 0x0800 )
    {
	    //ꍇɂđ召t]ij
	    int minBytes=min((int)bmp->rowbytes,(int)bmp_rowbytes);
	    //aloW͉n܂̂ŃXLC㉺t]B
    	for( int i=0 ; i < Height ; i++ )
	    {
		    //src|C^dst|C^"minBytes"TCY]
            for( int j=0 ; j < minBytes ; j++ )
            {
        	    dst[ bmp_rowbytes * ( limit - 1 ) + j ]=
                (char)( src[ (int)( bmp->rowbytes * i + j ) ] & (char)pixelMask );
            } //end for j
	    } //end for i
    }
    else
    if( ( bmp->pixbits & 0xFF00 ) == 0x1000 )
    {
        int red_pos=11;
        int green_pos=5;
        int blue_pos=0;
        int red_bits=5;
        int green_bits=6;
        int blue_bits=5;
        int red_mask=make_mask( red_bits );
        int green_mask=make_mask( green_bits );
        int blue_mask=make_mask( blue_bits );
        jUH *hsrc=(jUH *)bmp->baseaddr[0];
        for( int i=0 ; i < Height ; i++ )
        {
            for( int j=0 ; j < Width ; j++ )
            {
                //QoCgsNZl𓾂Ē`rbgtB[hɕAQTUKŐKB
                int pval=(int)( hsrc[ ( bmp->rowbytes * i + j * 2 )/2 ] );
                dst[ bmp_rowbytes * ( limit - i ) + j * 3     ]=(char)(( ((( pval >> blue_pos ) & blue_mask ) * 255 ) / blue_mask ) & pixelMask );        //Blue
                dst[ bmp_rowbytes * ( limit - i ) + j * 3 + 1 ]=(char)(( ((( pval >> green_pos ) & green_mask ) * 255 ) / green_mask ) & pixelMask );     //Green
                dst[ bmp_rowbytes * ( limit - i ) + j * 3 + 2 ]=(char)(( ((( pval >> red_pos ) & red_mask ) * 255 ) / red_mask ) & pixelMask );           //Red
           }
        }
    }    else
    if( ( bmp->pixbits & 0xFF00 ) == 0x2000 )
    {
        //1677F
        for( int i=0 ; i < Height ; i++ )
        {
            for( int j=0 ; j < Width ; j++ )
            {
                dst[ bmp_rowbytes * ( limit - i ) + j * 3     ]=(char)(src[ bmp->rowbytes * i + j * 4     ] & pixelMask );   //Blue
                dst[ bmp_rowbytes * ( limit - i ) + j * 3 + 1 ]=(char)(src[ bmp->rowbytes * i + j * 4 + 1 ] & pixelMask );   //Green
                dst[ bmp_rowbytes * ( limit - i ) + j * 3 + 2 ]=(char)(src[ bmp->rowbytes * i + j * 4 + 2 ] & pixelMask );   //Red
            }
        }
    }
}
//---------------------------------------------------------------------------
//`rbg}bvwb_쐬
//---------------------------------------------------------------------------
void IBMP::set_bitmapHeader( int width, int height )
{
	BITMAPFILEHEADER *bmfh=(BITMAPFILEHEADER *)( bm->Memory );
    bmfh->bfType=(WORD)( 'B' | ( 'M' << 8 ) );
    bmfh->bfSize=(DWORD)( get_bmp_allSize( width, height ) );
    bmfh->bfReserved1=0;
    bmfh->bfReserved2=0;
    bmfh->bfOffBits=(DWORD)( get_bmp_header_size() );
	BITMAPINFOHEADER *bmih=(BITMAPINFOHEADER *)((char *)(bm->Memory) + sizeof(BITMAPFILEHEADER) );
	bmih->biSize=sizeof(BITMAPINFOHEADER);
	bmih->biWidth=(DWORD)width;
	bmih->biHeight=(DWORD)height;
	bmih->biPlanes=1;
    if( pixel_bytes == 3 )
    	bmih->biBitCount=24;
    else
    //if( pixel_bytes == 1 )
		bmih->biBitCount=8;
	bmih->biCompression=BI_RGB;
	bmih->biSizeImage=bmp_rowbytes * height * pixel_bytes;
	bmih->biXPelsPerMeter=0;
	bmih->biYPelsPerMeter=0;
    if( pixel_bytes == 3 )
    {
    	bmih->biClrUsed=0;
        bmih->biClrImportant=0;
    }
    else
    //if( pixel_bytes == 1 )
    {
		bmih->biClrUsed=256;
		bmih->biClrImportant=256;
    }
}
//---------------------------------------------------------------------------
//J[pbgϊZbg
//---------------------------------------------------------------------------
void IBMP::set_rgb( RGBQUAD *rq )
{
	RGBQUAD *bmp_rgb=(RGBQUAD *)( (char *)(bm->Memory) + (int)sizeof(BITMAPFILEHEADER) + (int)sizeof(BITMAPINFOHEADER) );
    memcpy( (char *)bmp_rgb, (char *)rq, sizeof(RGBQUAD) * colors );
}
/*
//---------------------------------------------------------------------------
//J[pbg쐬
//---------------------------------------------------------------------------
bool IBMP::make_palette( RGBQUAD *rq )
{
	if( logpal != NULL )	delete [] logpal;
    logpal=(LPLOGPALETTE)( new char [ sizeof(LOGPALETTE) + sizeof(PALETTEENTRY) * colors ] );
    memset( (char *)logpal, sizeof(LOGPALETTE) + sizeof(PALETTEENTRY) * colors, 0 );
    logpal->palVersion=(WORD)0x300;
    logpal->palNumEntries=(WORD)colors;
	for( int i=0 ; i < colors ; i++ )
    {
    	logpal->palPalEntry[i].peRed=rq[i].rgbRed;
        logpal->palPalEntry[i].peGreen=rq[i].rgbGreen;
        logpal->palPalEntry[i].peBlue=rq[i].rgbBlue;
        logpal->palPalEntry[i].peFlags=PC_RESERVED;
    } //for i
    hpal=CreatePalette( logpal );
    //if( hpal == NULL ) ShowMessage("fail Pal");
    return ( hpal != NULL );
}
*/
/*
old implement
//---------------------------------------------------------------------------
//PUFsNZQTUFsNZϊóiQi_joCgPʁj
//---------------------------------------------------------------------------
void IBMP::output_pixel16( const int &x_hseq, const int &yno, const jUH &vuh )
{
	int seq=x_hseq * 2 ;
    if( seq > Width )
    	return;
    int offset=( Height - yno - 1 ) * bmp_rowbytes + seq;
    jUH *bitmap=(jUH *)( (char *)(bm->Memory) + get_bmp_header_size() + offset );
    *bitmap=vuh;
}
//---------------------------------------------------------------------------
//QoCgPʂœǂŁAQoCgPʁirbgOrbgPT܂łPUhbgjŏo͂
//---------------------------------------------------------------------------
void IBMP::conv_pixel16( const int &xno, const int &yno, const jUH &pv0, const jUH &pv1, const jUH &pv2, const jUH &pv3 )
{
	jUB va,vb;
	jUB value0,value1,value2,value3;
	va=vb=0;
    int hseq;
    jUH vuh;
	for( int i=7 ; i >= 0 ; i-- )
	{
		value3 =(jUB)((  pv3 >> i ) & (jUH)0x0001);
		value2 =(jUB)((  pv2 >> i ) & (jUH)0x0001);
		value1 =(jUB)((  pv1 >> i ) & (jUH)0x0001);
		value0 =(jUB)((  pv0 >> i ) & (jUH)0x0001);
		if( i % 2 == 0 )
		{
        	hseq=3 - ( i / 2 ) + xno * 8;
			vb=(jUB)(( value3 << 3 ) | ( value2 << 2 ) | ( value1 << 1 ) | value0);
            vuh=(jUH)( va | ( vb << 8 ));
			output_pixel16( hseq, yno, vuh );
		}
		else
			va=(jUB)(( value3 << 3 ) | ( value2 << 2 ) | ( value1 << 1 ) | value0);
	}
	for( int i=15 ; i >= 8 ; i-- )
	{
		value3 =(jUB)((  pv3 >> i ) & (jUH)0x0001);
		value2 =(jUB)((  pv2 >> i ) & (jUH)0x0001);
		value1 =(jUB)((  pv1 >> i ) & (jUH)0x0001);
		value0 =(jUB)((  pv0 >> i ) & (jUH)0x0001);
		if( i % 2 == 0 )
		{
        	hseq=7 - ( i / 2 ) + 4 + xno * 8;
			vb=(jUB)(( value3 << 3 ) | ( value2 << 2 ) | ( value1 << 1 ) | value0);
            vuh=(jUH)( va | ( vb << 8 ));
			output_pixel16( hseq, yno, vuh );
		}
		else
			va=(jUB)(( value3 << 3 ) | ( value2 << 2 ) | ( value1 << 1 ) | value0);
	}
}
//---------------------------------------------------------------------------
//sNZ}XNtłQoCgPʂœǂŁAQoCgPʁirbgOrbgPT܂łPUhbgjŏo͂
//---------------------------------------------------------------------------
void IBMP::conv_pixel16( const int &xno, const int &yno, const jUH &pv0, const jUH &pv1, const jUH &pv2, const jUH &pv3, const jUB &pixelmask )
{
	jUB va,vb;
	jUB value0,value1,value2,value3;
	va=vb=0;
    int hseq;
    jUH vuh;
	for( int i=7 ; i >= 0 ; i-- )
	{
		value3 =(jUB)((  pv3 >> i ) & (jUH)0x0001);
		value2 =(jUB)((  pv2 >> i ) & (jUH)0x0001);
		value1 =(jUB)((  pv1 >> i ) & (jUH)0x0001);
		value0 =(jUB)((  pv0 >> i ) & (jUH)0x0001);
		if( i % 2 == 0 )
		{
        	hseq=3 - ( i / 2 ) + xno * 8;
			vb=(jUB)(( value3 << 3 ) | ( value2 << 2 ) | ( value1 << 1 ) | value0);
            va=(jUB)( va & pixelmask );
            vb=(jUB)( vb & pixelmask );
            vuh=(jUH)( va | ( vb << 8 ));
			output_pixel16( hseq, yno, vuh );
		}
		else
			va=(jUB)(( value3 << 3 ) | ( value2 << 2 ) | ( value1 << 1 ) | value0);
	}
	for( int i=15 ; i >= 8 ; i-- )
	{
		value3 =(jUB)((  pv3 >> i ) & (jUH)0x0001);
		value2 =(jUB)((  pv2 >> i ) & (jUH)0x0001);
		value1 =(jUB)((  pv1 >> i ) & (jUH)0x0001);
		value0 =(jUB)((  pv0 >> i ) & (jUH)0x0001);
		if( i % 2 == 0 )
		{
        	hseq=7 - ( i / 2 ) + 4 + xno * 8;
			vb=(jUB)(( value3 << 3 ) | ( value2 << 2 ) | ( value1 << 1 ) | value0);
            va=(jUB)( va & pixelmask );
            vb=(jUB)( vb & pixelmask );
            vuh=(jUH)( va | ( vb << 8 ));
			output_pixel16( hseq, yno, vuh );
		}
		else
			va=(jUB)(( value3 << 3 ) | ( value2 << 2 ) | ( value1 << 1 ) | value0);
	}
}
/*
//---------------------------------------------------------------------------
//PaPUFv[EsNZϊo
// input: bmp
// output: TMemoryStream *bm
//---------------------------------------------------------------------------
void IBMP::Convert1Bimage( jBMP bmp )
{
    jUH wvalue[4];
    jUH *uw;
    int planes=bmp->planes;
	//[hPʂŃsNZ}bvɕϊ\
    for( int j=0 ; j < Height ; j++ )
    {
    	for( int i=0 ; i < bmp->rowbytes ; i++ ) //row_limit ; i++ )
        {
        	for( int h=0 ; h < planes ; h++ )
            {
            	//NULL̃v[͓]Ȃ
            	if( bmp->baseaddr[h] == NULL )
                	wvalue[h]=0;
                else
                {
                	uw=(jUH *)((jUB *)(bmp->baseaddr[h] + i * 2 + bmp->rowbytes * j ));
                	wvalue[h]=*uw;
                } //if
            } //h
            conv_pixel16( i, j, wvalue[0], wvalue[1], wvalue[2], wvalue[3] );
    	} // i
    } //j
} //end func
//---------------------------------------------------------------------------
// sNZ}XNtPaPUFv[EsNZϊo
// input: bmp
// output: TMemoryStream *bm
//---------------------------------------------------------------------------
void IBMP::Convert1Bimage( jBMP bmp, const jUB &pixelMask )
{
    jUH wvalue[4];
    jUH *uw;
    int planes=bmp->planes;
	//[hPʂŃsNZ}bvɕϊ\
    for( int j=0 ; j < Height ; j++ )
    {
    	for( int i=0 ; i < bmp->rowbytes ; i++ )
        {
        	for( int h=0 ; h < planes ; h++ )
            {
            	//NULL̃v[͓]Ȃ
            	if( bmp->baseaddr[h] == NULL )
                	wvalue[h]=0;
                else
                {
                	uw=(jUH *)((jUB *)(bmp->baseaddr[h] + i * 2 + bmp->rowbytes * j ));
                	wvalue[h]=*uw;
                } //if
            } //h
            conv_pixel16( i, j, wvalue[0], wvalue[1], wvalue[2], wvalue[3], pixelMask );
    	} // i
    } //j
} //end func
*/
//---------------------------------------------------------------------------
//PaPUFv[EsNZϊo
// input: bmp
// output: TMemoryStream *bm
//---------------------------------------------------------------------------
void IBMP::Convert1Bimage( jBMP bmp )
{
    int planes=bmp->planes;
	//v[O
    if( bmp->baseaddr[0] != NULL )
    {
    	for( int i=0 ; i < Height ; i++ )
    	{
    		jUB *src=(jUB *)( bmp->baseaddr[0] + bmp->rowbytes * i );
    		jUB *dst=(jUB *)( (jUB *)(bm->Memory) + get_bmp_header_size() + ( Height - i - 1 ) * bmp_rowbytes );
    		for( int j=0 ; j < Width ; j++ )
        	{
        		int row=j / 8;
                int bit=j % 8;
                if( (( src[row] >> ( 7 - bit )) & 0x01 ) != 0 )
                 	dst[j]=(jUB)0x01;
                else
                	dst[j]=(jUB)0x00;

        	} //width
    	} //heigth
    }
    else
    {
    	char *dst=(char *)( (char *)(bm->Memory) + get_bmp_header_size() );
    	for( int i=0 ; i < get_bmp_size( Width, Height ) ; i++ )
        {
        	dst[i]=(char)0;
        }
    } //plane : 0
	//v[P`R
    for( int h=1 ; h < planes ; h++ )
    {
    	if( bmp->baseaddr[0] == NULL )
        	break;
    	for( int i=0 ; i < Height ; i++ )
    	{
    		char *src=(char *)( bmp->baseaddr[h] + bmp->rowbytes * i );
    		char *dst=(char *)( (char *)(bm->Memory) + get_bmp_header_size() + ( Height - i - 1 ) * bmp_rowbytes );
    		for( int j=0 ; j < Width ; j++ )
        	{
        		int row=j / 8;
                int bit=j % 8;
            	//if( row > bmp->rowbytes )
            	//	break;
                if( (( src[row] >> ( 7 - bit )) & 0x01 )!= 0 )
                	dst[j]=(char)( dst[j] | (char)( 0x01 << h ) );
        	} //width
    	} //heigth
    } //planes
} //end func
//---------------------------------------------------------------------------
// sNZ}XNtPaPUFv[EsNZϊo
// input: bmp
// output: TMemoryStream *bm
//---------------------------------------------------------------------------
void IBMP::Convert1Bimage( jBMP bmp, const jUB &pixelMask )
{
    int planes=bmp->planes;
	//v[O
    if( bmp->baseaddr[0] != NULL )
    {
    	for( int i=0 ; i < Height ; i++ )
    	{
    		jUB *src=(jUB *)( bmp->baseaddr[0] + bmp->rowbytes * i );
    		jUB *dst=(jUB *)( (jUB *)(bm->Memory) + get_bmp_header_size() + ( Height - i - 1 ) * bmp_rowbytes );
    		for( int j=0 ; j < Width ; j++ )
        	{
        		int row=j / 8;
                int bit=j % 8;
                if( (( src[row] >> ( 7 - bit )) & 0x01 ) != 0 )
                 	dst[j]=(jUB)( 0x01 & pixelMask );
                else
                	dst[j]=(jUB)0x00;

        	} //width
    	} //heigth
    }
    else
    {
    	char *dst=(char *)( (char *)(bm->Memory) + get_bmp_header_size() );
    	for( int i=0 ; i < get_bmp_size( Width, Height ) ; i++ )
        {
        	dst[i]=(char)0;
        }
    } //plane : 0
	//v[P`R
    for( int h=1 ; h < planes ; h++ )
    {
    	if( bmp->baseaddr[0] == NULL )
        	break;
    	for( int i=0 ; i < Height ; i++ )
    	{
    		char *src=(char *)( bmp->baseaddr[h] + bmp->rowbytes * i );
    		char *dst=(char *)( (char *)(bm->Memory) + get_bmp_header_size() + ( Height - i - 1 ) * bmp_rowbytes );
    		for( int j=0 ; j < Width ; j++ )
        	{
        		int row=j / 8;
                int bit=j % 8;
            	//if( row > bmp->rowbytes )
            	//	break;
                if( (( src[row] >> ( 7 - bit )) & 0x01 )!= 0 )
                	dst[j]=(char)(( dst[j] | (char)( 0x01 << h ) ) & pixelMask );
        	} //width
    	} //heigth
    } //planes
} //end func
//---------------------------------------------------------------------------
// asqnmC[W֕ϊ
//---------------------------------------------------------------------------
bool IBMP::Convert( jBMP bmp )
{
	set_bitmapHeader( Width, Height );

    //char msg[100];
    //sprintf(msg,"(1)pixel_mask=%x", pixel_mask );
    //ShowMessage(msg);

	//1B 16F( color: 0x0009, compac : 0, cinfo[0] : 0)
	if( bmp->planes == 4 && ( bmp->pixbits & 0xFF00 ) == 0x0100 )
    {
    	if( pixel_mask == (jUB)0x01 )
    		Convert1Bimage( bmp );
        else
        	Convert1Bimage( bmp, pixel_mask );
        return true;
    }
    else
    //3B 256F( color: 0x0009, compac : 0 )
    if( bmp->planes == 1 && ( bmp->pixbits & 0xFF00 ) == 0x0800 )
    {
        //fobOA}XNt`֐܂`łĂȂIiC2000.9.17j
    	//if( pixel_mask == (jUB)0x08 )
		 Convert3Bimage( bmp );
        //else
        //256FoȂRA}XNtH
        //	Convert3Bimage( bmp, pixel_mask );

    //char msg[100];
    //sprintf(msg,"256 pixel_mask=%x", pixel_mask );
    //ShowMessage(msg);

        //Convert3Bimage( bmp, 0xFF );
        return true;
    }
    else
    //24 bits colors no compression
    //  color: 0x0001, compac : 0 , cinfo[o]:0 , cinfo[1]=0x0008, cinfo[2]=0x0808, cinfo[3]=0x0F08
	//eF̊KWrbgłȂꍇ́A炩ߐKgrst_bmpɓn
    if( bmp->planes == 1 && ( bmp->pixbits & 0xFF00 ) > 0x0800 )
    {
    	if( ( ( bmp->pixbits >> 8 ) & 0x00FF ) == ( bmp->pixbits & 0x00FF ) )
			Convert3Bimage( bmp );
        else
        	Convert3Bimage( bmp, pixel_mask );
        return true;
    }
    else
    	return false;
}
//---------------------------------------------------------------------------
// TBitmap to TAD Bitmap Class Method
//---------------------------------------------------------------------------
// RXgN^(TBitmapbmpɕϊj(bmp͂炩ߊmۂĂ邱Ɓj
//---------------------------------------------------------------------------
TTBMP::TTBMP( Graphics::TBitmap *tbmp, jBMP bmp )
{
	_tbmp=tbmp;
    _bmp=bmp;
    _result=true;
    if( _tbmp == NULL ) _result=false;
    if( _bmp == NULL )
    	_result=false;
    else
    {
    	bool plane_flag=false;
        if( bmp->baseaddr[0] != NULL )
        	plane_flag=true;
        /*
    	for( int i=0 ; i < bmp->planes ; i++ )
        {
        	if( bmp->baseaddr[ i ] != NULL )
            	plane_flag=true;
        }
        */
        if( plane_flag == false )
        	_result=false;
    }
    //F͎ԂȂ̂ŃtJ[TAD bmpׂ݈̂
    if( (( bmp->pixbits >> 8 ) & 0x00FF ) != 24 )
    	_result=false;
}
//---------------------------------------------------------------------------
// TBitmaptJ[TAD BMPɕϊ
//---------------------------------------------------------------------------
bool TTBMP::Convert(void)
{
	if( !Check() )	return false;
	jUB *bar;
    bar=(jUB *)( _bmp->baseaddr[0] );
    if( bar == NULL ) return false;
    bar[0]=0;
	for( int y=0 ; y < _tbmp->Height ; y++ )
    {
    	for( int x=0 ; x < _tbmp->Width ; x++ )
        {
        	TColor tc=_tbmp->Canvas->Pixels[x][y];
            int index=_bmp->rowbytes * y + x * 3;
            bar[ index ]=(jUB)( tc >> 16 );	index++;	//Blue
            bar[ index ]=(jUB)( tc >>  8 );	index++;	//Green
            bar[ index ]=(jUB)(    tc    );				//Red
        } //y
    } //x
    return true;
}
//---------------------------------------------------------------------------
// TAD bitmap Class method
//---------------------------------------------------------------------------
// RXgN^
//---------------------------------------------------------------------------
TBMP::TBMP()
{
	_result=false;
    _bmp=NULL;
    _planes=0;
}
//---------------------------------------------------------------------------
// TAD bitmap 
// half open
//---------------------------------------------------------------------------
bool TBMP::Create( jH planes, jH bpix, jH epix, jH x0, jH y0, jH x1, jH y1 )
{
	if( Check() )
    	Destroy();
	_result=true;
    _bmp=NULL;
	if( planes == 0 )
    {
    	_result=false;
        return false;
    }
    if( planes > 28 )
    	planes=28;
    if(( x0 == x1 ) || ( y0 == y1 ))
    {
    	_result=false;
        return false;
    }
    _planes=planes;
    int remain_planes=0;
    if( planes > 4 )
    {
    	remain_planes=planes - 4;
    }
    _bmp=(jBMP)( new char [ sizeof(jBITMAP) + sizeof(jUB*) * remain_planes ] );
    if( _bmp == NULL )
    {
    	_result=false;
        return false;
    }
    for( int i=0 ; i < planes ; i++ )
    {
    	_bmp->baseaddr[i]=NULL;
    }
    jRECT r;
    if( x0 > x1 )
    {
    	jH temp=x0;
        x0=x1;
        x1=temp;
    }
    if( y0 > y1 )
    {
    	jH temp=y0;
        y0=y1;
        y1=temp;
    }
    r.c.left=x0;
    r.c.top=y0;
    r.c.right=x1;
    r.c.bottom=y1;
    int width=x1 - x0;
    int height=y1 - y0;
    if( bpix > 32 )
    	bpix=32;
    if( epix > 28 )
    	epix=28;
    if( bpix < epix )
    	epix=bpix;
    if(( epix * planes ) > 28 )
    {
    	_result=false;
        delete _bmp;
        _bmp=NULL;
        return false;
    }
    _bmp->planes=planes;
    _bmp->pixbits=(jH)(( bpix << 8 ) | epix );
    _bmp->rowbytes=(jH)((( bpix * width + 15 ) / 16 ) * 2 );
    _bmp->bounds=r;
    int size=_bmp->rowbytes * height;
    bool planes_flag=true;
    for( int i=0 ; i < planes ; i++ )
    {
    	_bmp->baseaddr[ i ]=new jUB [ size ];
        if( _bmp->baseaddr[ i ] == NULL )
        	planes_flag=false;
        else
        	memset( _bmp->baseaddr[i], 0xFF, size );
    }
    
    //if( planes_flag )
    //{
    //char msg[100];
    //sprintf(msg,"true planes=%d w=%d h=%d size=%d b=%d bpix=%x rowbytes=%d", planes, width, height, size, bpix, _bmp->pixbits, _bmp->rowbytes );
    //ShowMessage(msg); }

    if( planes_flag == false )
    {
    	_result=true;
        Destroy();
        return false;
    }
    return true;
}
//---------------------------------------------------------------------------
// TAD bitmap RXgN^
//---------------------------------------------------------------------------
TBMP::TBMP( jH planes, jH bpix, jH epix, jH x0, jH y0, jH x1, jH y1 )
{
	_result=false;
    _result=Create( planes, bpix, epix, x0, y0, x1, y1 );
}
//---------------------------------------------------------------------------
// 
//---------------------------------------------------------------------------
void TBMP::Destroy(void)
{
	if( Check() == false )	return;
    if( _bmp == NULL ) return;
    for( int i=0 ; i < _planes ; i++ )
    {
    	if( _bmp->baseaddr[i] == NULL )
        	continue;
        else
        {
        	delete _bmp->baseaddr[i];
            _bmp->baseaddr[i]=NULL;
        }
    } //for i
    delete _bmp;
    _bmp=NULL;
    _result=false;
}
//---------------------------------------------------------------------------
// fXgN^
//---------------------------------------------------------------------------
TBMP::~TBMP()
{
	Destroy();
}
//---------------------------------------------------------------------------
// bitmapԂB
//---------------------------------------------------------------------------
bool TBMP::Get( jBMP *bmp )
{
	if( Check() == false )
    {
    	*bmp=NULL;
        return false;
    }
    *bmp=_bmp;
    return true;
}
//---------------------------------------------------------------------------
// `rƋ`š`aɕԂBꍇ͐^ԂB
//---------------------------------------------------------------------------
bool and_rect( jRECT *r, jRECT *s, jRECT *a )
{
	a->c.left=max(r->c.left,s->c.left);
    a->c.right=min(r->c.right,s->c.right);
    a->c.top=min(r->c.top,s->c.top);
    a->c.bottom=max(r->c.bottom,s->c.bottom);
    return (( a->c.left <= a->c.right ) && ( a->c.top <= a->c.bottom ));
}
//---------------------------------------------------------------------------
// `rƋ`s傫̋`H
//---------------------------------------------------------------------------
bool equal_size_rect( jRECT *r, jRECT *s )
{
	jH rw=(jH)( r->c.right - r->c.left );
    jH rh=(jH)( r->c.bottom - r->c.top );
	jH sw=(jH)( s->c.right - s->c.left );
    jH sh=(jH)( s->c.bottom - s->c.top );
    return ( rw == sw && rh == sh );
}
//---------------------------------------------------------------------------
// API: grst_bmp Restore Bitmap
// rbg}bv̉
// ]` br : Ɨrbg}bvbmap̒̋`̈(br,bmap->bounds̋ʕj
// ]` gr : `gidIuWFNg̃rbg}bv̒Ŏw肵`̈
// `惂[h mode
// }XN     mask : gidł̍W`,NULLȊOKp
//---------------------------------------------------------------------------
jERR __fastcall DisplayPrimitive::grst_bmp( jRP gr, jBMP bmap, jRP br, jGSCAN *mask, jDCM mode )
{
	CHECK_GID;
    if( br == NULL )
    	return jEG_PAR;
    if( !( ( mode >= jG_STORE && mode <= jG_ANDN ) || ( mode == jG_CVFORM ) ) )
    	return jEG_PAR;
    jRECT ar;
    if( !and_rect( &bmap->bounds, br, &ar ) )
    	return jEG_PAR;
    //LsNZ}XNݒ
    gset_msk( (jW)make_mask( bmap->pixbits & 0x00FF ) );
    jW pixelmask;
    gget_msk( &pixelmask );
    IBMP ibmp( bmap, _palette, BASE_COLORS, (jUB)pixelmask );
    if( ibmp.result < 0 )
    	return ibmp.result;
    jRECT ggr;
    if( gr == NULL )
    	ggr=*br;
    else
    	ggr=*gr;
    //摜
    Graphics::TBitmap *tbmp=new Graphics::TBitmap;
    if( tbmp == NULL )
    	return jEG_NOSPC;
    TMemoryStream *ibs=ibmp.Stream();
    tbmp->LoadFromStream( ibs );
    //J[pbg̐ݒ(when 256 colors)
    //if( ibmp.palette() != NULL )
    // 	tbmp->Palette=ibmp.palette();
    ////tbmp->SaveToFile( "test.bmp" );	//dump debug
    ////ibs->SaveToFile( "test2.bmp" ); //dump debug

    //A݂gid̍ŐVNbv̈̓Kp
    //_clip.set_clip( canvas->Handle );
    //`惂[hݒ
    long rop;
    convert_mode_rop( mode, rop );
    canvas->CopyMode=rop;
    //masking
    if( mask == NULL )
    {
    	//}XNȂꍇ
    	if( equal_size_rect( &ar, &ggr ) )
        {
        	canvas->Draw( (int)ggr.c.left, (int)ggr.c.top, tbmp );
        }
        else
        {
        	Graphics::TBitmap *temp_bmp=new Graphics::TBitmap;
            if( temp_bmp == NULL )
            {
            	delete tbmp;
                return jEG_NOSPC;
            }
        	tbmp->Canvas->CopyRect( Rct(ar), temp_bmp->Canvas, Rct(ar) );
    		canvas->StretchDraw( Rct(ggr), temp_bmp );
            delete temp_bmp;
        }
    }
    else
    {
    	//mask
        Graphics::TBitmap *dst_bmp=new Graphics::TBitmap;
        if( dst_bmp == NULL )
        {
        	//`惏[NmۂłȂꍇ
        	if( equal_size_rect( &ar, &ggr ) )
            	canvas->Draw( (int)ggr.c.left, (int)ggr.c.top, tbmp );
            else
            {
            	Graphics::TBitmap *temp_bmp=new Graphics::TBitmap;
            	if( temp_bmp == NULL )
            	{
            		delete tbmp;
                	return jEG_NOSPC;
            	}
        		tbmp->Canvas->CopyRect( Rct(ar), temp_bmp->Canvas, Rct(ar) );
    			canvas->StretchDraw( Rct(ggr), temp_bmp );
            	delete temp_bmp;
            }
            return jEG_NOSPC;
        }
        else
        {
        	//`惏[N֕`
        	if( equal_size_rect( &ar, &ggr ) )
            {
            	//PFŏɃTCYZbgȂΕ`悳Ȃ
            	dst_bmp->Width=(int)( ggr.c.right - ggr.c.left );
                dst_bmp->Height=(int)( ggr.c.bottom - ggr.c.top );
            	dst_bmp->Canvas->Draw( (int)ggr.c.left, (int)ggr.c.top, tbmp );
            }
            else
            {
            	Graphics::TBitmap *temp_bmp=new Graphics::TBitmap;
            	if( temp_bmp == NULL )
            	{
            		delete tbmp;
                    delete dst_bmp;
                	return jEG_NOSPC;
            	}
                temp_bmp->Width=(int)( ar.c.right - ar.c.left );
                temp_bmp->Height=(int)( ar.c.bottom - ar.c.top );
        		tbmp->Canvas->CopyRect( Rct(ar), temp_bmp->Canvas, Rct(ar) );
                dst_bmp->Width=(int)( ggr.c.right - ggr.c.left );
                dst_bmp->Height=(int)( ggr.c.bottom - ggr.c.top );
    			dst_bmp->Canvas->StretchDraw( Rct(ggr), temp_bmp );
            	delete temp_bmp;
            }
        }
        //듮h~
        if( mask->nr < 0 ) mask->nr=0;
        //GSCAN mask
		for( int nr_index=0 ; nr_index < (int)(mask->nr) ; nr_index++ )
        {
            if( mask->rs[nr_index] == NULL )
            	continue;
            int half_nh=(int)( mask->rs[nr_index]->nh / 2 );
            int draw_y=(int)( ggr.c.top + mask->sy + nr_index );
            //RSCAN
        	for( int nh_index=0 ; nh_index < half_nh ; nh_index++ )
            {
            	//RSCANf[^ЂƂɓ]
            	TRect r=Rect( ggr.c.left + mask->bx + mask->rs[nr_index]->h[ nh_index * 2 ],
                			 draw_y,
                             ggr.c.left + mask->bx + mask->rs[nr_index]->h[ nh_index * 2 + 1 ],
                             draw_y + 1 );
                canvas->CopyRect( r, dst_bmp->Canvas, r );
                //visual debug
                //canvas->Brush->Color=clBlack;
                //canvas->Brush->Style=bsSolid;
                //canvas->Pen->Color=clBlack;
                //canvas->Rectangle( r.Left, r.Top, r.Right, r.Bottom );
            } //for nh_index
        } //for nr_index
        delete dst_bmp;
    } //if mask
    delete tbmp;
	return jEG_OK;
}
//---------------------------------------------------------------------------
// (for lib)bitmap bmpōryʒuɂĊJnrxWXLA
// RSCAN̘ȀI[_nx߂Bs͋UԂAsI[ʒunxԂB
// width(jBMP) <= bmp->Width
//---------------------------------------------------------------------------
bool get_rscan( Graphics::TBitmap *bmp, int width, int rx, int ry, int *nx )
{
    if( bmp->Canvas->Pixels[rx][ry] == clWhite )
    {
    	//}XNłȂI[߂B
    	for( int i=rx ; i < width ; i++ )
        {
        	if( bmp->Canvas->Pixels[i][ry] != clWhite )
            {
            	*nx=i;
                return false;
            } //if
        } //for i
        *nx=width;
        return false;
    }
    else
    {
    	//}XN̏I[(half open)߂B
		for( int i=rx ; i < width ; i++ )
    	{
        	if( bmp->Canvas->Pixels[i][ry] == clWhite )
            {
            	*nx=i;
                return true;
            }
    	} //for i
        *nx=width;
        return true;
    } //if
}
//---------------------------------------------------------------------------
// lib:rbg}bvbmpCӐ}`mask𐶐Bingrel_mskōsj
// bmp̓v[̏ꍇ́A}XÑv[w肷Ƃ悢B
// iimgae maskGSCANɕϊ̂߁j
// ̗eՂɂAœC[WgpBvbgtH[قȂꍇ͍lB
//---------------------------------------------------------------------------
jERR __fastcall DisplayPrimitive::gcre_msk( jBMP bmp, jGSCAN **mask )
{
    //LsNZ}XNݒ
    gset_msk( (jW)( bmp->pixbits & 0x00FF ) );
    jW pixelmask;
    gget_msk( &pixelmask );
    IBMP ibmp( bmp, _palette, BASE_COLORS, (jUB)pixelmask );
    if( ibmp.result < 0 )
    	return ibmp.result;
    //GSCANm
    *mask=(jGSCAN *)( new char [ ( sizeof(jH) * 3 + sizeof(jRSCAN) * ibmp.height() ) ] );
    if( *mask == NULL )
    	return jEG_NOSPC;
    (*mask)->sy=(jH)0;
    (*mask)->bx=(jH)0;
    (*mask)->nr=(jH)ibmp.height();
    //摜
    Graphics::TBitmap *tbmp=new Graphics::TBitmap;
    if( tbmp == NULL )
    	return jEG_NOSPC;
    TMemoryStream *ibs=ibmp.Stream();
    tbmp->LoadFromStream( ibs );
    //RSCAN h[NH} workm
    char *_rbuf;
    _rbuf= new char [ sizeof(jH) * ( tbmp->Width + 1 ) ] ;
    jRSCAN *rbuf=(jRSCAN *)_rbuf;
    if( rbuf == NULL )
    {
    	delete tbmp;
        delete *mask;
        //mask=NULL;
        return jEG_NOSPC;
    }
    for( int j=0 ; j < tbmp->Height ; j++ )
    {
    	int sta=0;
        int nxt;
        int count=0;	//QłPJEg
        rbuf->nh=0;
        //}XNWlZbg
    	for( ; ; )
        {
        	if( get_rscan( tbmp, ibmp.width(), sta, j, &nxt ) )
            {
            	rbuf->h[ count * 2 ]=(jH)sta;
                rbuf->h[ count * 2 + 1 ]=(jH)nxt;
                count++;
                rbuf->nh=(jH)( count * 2 );
                sta=nxt + 1;
            }
            else
            {
            	sta=nxt;
            }
            if( sta >= ibmp.width() )
            	break;
        } //for
        //RSCAN̊mېݒ
        if( rbuf->nh == 0 )
        {
        	(*mask)->rs[j]=NULL;
        }
        else
        {
        	int size=sizeof(jH) * ( rbuf->nh + 1 );
        	jRSCAN *wk=(jRSCAN *)( new char [ size ] );
            if( wk == NULL )
            	(*mask)->rs[j]=NULL;
            else
            {
            	memcpy( (char *)wk, (char *)rbuf, size );
                (*mask)->rs[j]=wk;
            }
        } //if
    } //for j
    //delete rbuf;
    delete[] _rbuf;
    delete tbmp;
	return jEG_OK;
}
//---------------------------------------------------------------------------
// lib:CӐ}`maskB
//---------------------------------------------------------------------------
jERR __fastcall DisplayPrimitive::grel_msk(jGSCAN **mask)
{
	if( *mask == NULL )
    	return jEG_PAR;
	for( int i=0 ; i < (int)( (*mask)->nr ) ; i++ )
    {
    	if( (*mask)->rs[i] != NULL )
        	delete [] (*mask)->rs[i];
    } //for
    delete [] *mask;
    return jEG_OK;
}
//---------------------------------------------------------------------------
// API: gsav_bmp Save Bitmap
// rbg}bv̕ۑ
// ]` br : Ɨrbg}bvbmap̒̋`̈(br,bmap->bounds̋ʕj
// ]` gr : `gidIuWFNg̃rbg}bv̒Ŏw肵`̈
// `惂[h mode
// }XN     mask : gidł̍W`,NULLȊOKp
//---------------------------------------------------------------------------
jERR __fastcall DisplayPrimitive::gsav_bmp( jRP gr, jBMP bmap, jRP br, jGSCAN *mask, jDCM mode )
{
	CHECK_GID;
    if( gr == NULL )
    	return jEG_PAR;
    jRECT *_br;
    if( br == NULL )
    	_br=gr;
    if( !( ( mode >= jG_STORE && mode <= jG_ANDN ) || ( mode == jG_CVFORM ) ) )
    	return jEG_PAR;
    jRECT ar;
    if( !and_rect( &bmap->bounds, _br, &ar ) )
    	return jEG_PAR;
    //LsNZ}XNݒ
    gset_msk( (jW)( bmap->pixbits & 0x00FF ) );
    jW pixelmask;
    gget_msk( &pixelmask );
    //]gk؂
    long rop;
    convert_mode_rop( jG_STORE, rop );
    canvas->CopyMode=rop;
    Graphics::TBitmap *src_bmp=new Graphics::TBitmap;    //摜
    if( src_bmp == NULL )
    	return jEG_NOSPC;
    src_bmp->Width=(int)( _br->c.right - _br->c.left );
    src_bmp->Height=(int)( _br->c.bottom - _br->c.top );
    TRect ggr=Rect( (int)gr->c.left, (int)gr->c.top, (int)gr->c.right, (int)gr->c.bottom );
    TRect bbr=Rect( (int)_br->c.left, (int)_br->c.top, (int)_br->c.right, (int)_br->c.bottom );
    src_bmp->Canvas->CopyRect( bbr, canvas, ggr );
    //]rbg}bvm
    IBMP ibmp( bmap, _palette, BASE_COLORS, (jUB)pixelmask );
    if( ibmp.result < 0 )
    	return ibmp.result;
    Graphics::TBitmap *dst_bmp=new Graphics::TBitmap;    //摜
    if( dst_bmp == NULL )
    {
    	delete src_bmp;
    	return jEG_NOSPC;
    }
    TMemoryStream *ibs=ibmp.Stream();
    dst_bmp->LoadFromStream( ibs );
    //A݂gid̍ŐVNbv̈̓Kp
    //_clip.set_clip( canvas->Handle );
    //`惂[hݒ
    convert_mode_rop( mode, rop );
    src_bmp->Canvas->CopyMode=rop;
    //masking
    if( mask == NULL )
    {
    	//}XNȂꍇ
        dst_bmp->Canvas->CopyRect( bbr, src_bmp->Canvas, bbr );

    	//src_bmp->SaveToFile( "sav1.bmp" );	//dump debug
    	//dst_bmp->SaveToFile( "sav2.bmp" );	//dump debug

        //BTRON Bitmap object̐
        TTBMP ttbmp( dst_bmp, bmap );
        if( ttbmp.Convert() )
        {
        	//if( src_bmp != NULL ) delete src_bmp;
            //if( dst_bmp != NULL ) delete dst_bmp;
            return jEG_OK;
        }
        else
        {
        	//if( src_bmp != NULL ) delete src_bmp;
            //if( dst_bmp != NULL ) delete dst_bmp;
            return jEG_ADR;
        }
    }
    else
    {
    	//mask
        //듮h~
        if( mask->nr < 0 ) mask->nr=0;
        //GSCAN mask
		for( int nr_index=0 ; nr_index < (int)(mask->nr) ; nr_index++ )
        {
            if( mask->rs[nr_index] == NULL )
            	continue;
            int half_nh=(int)( mask->rs[nr_index]->nh / 2 );
            int draw_y=(int)( _br->c.top + mask->sy + nr_index );
            //RSCAN
        	for( int nh_index=0 ; nh_index < half_nh ; nh_index++ )
            {
            	//RSCANf[^ЂƂɓ]
            	TRect r=Rect( _br->c.left + mask->bx + mask->rs[nr_index]->h[ nh_index * 2 ],
                			  draw_y,
                              _br->c.left + mask->bx + mask->rs[nr_index]->h[ nh_index * 2 + 1 ],
                              draw_y + 1 );
                src_bmp->Canvas->CopyRect( r, dst_bmp->Canvas, r );
            } //for nh_index
        } //for nr_index
        TTBMP ttbmp( dst_bmp, bmap );
        if( ttbmp.Convert() )
        {
        	//if( src_bmp != NULL ) delete src_bmp;
            //if( dst_bmp != NULL ) delete dst_bmp;
            return jEG_OK;
        }
        else
        {
        	//if( src_bmp != NULL ) delete src_bmp;
            //if( dst_bmp != NULL ) delete dst_bmp;
            return jEG_ADR;
        }
    } //if mask
} //end gsav_bmp
