//---------------------------------------------------------------------------
//
//	  y TAD viewer for Windows z
//    TAD stream library
//	  JJ,micropower,HigashiHiroshima City,1997
//
//---------------------------------------------------------------------------
#ifndef __TADSTREAMH__
#define __TADSTREAMH__
#include <vcl\printers.hpp>
#include "btype32.h"
#include "tadseg.h"
#include "btad.h"
#include "dp.h"
#include "dpclass.h"
#include "bcolor.h"
#include "tadid.h"
#include "taddata.h"
#include "clip.h"
#include "er_eg.h"
#include "property.h"
#include "bfont.h"
//---------------------------------------------------------------------------
#pragma option -a1
#pragma nopackwarning
typedef struct {
#ifdef BIGENDIAN
	jB upper;
	jB lower;
#else
	jB lower;
	jB upper;
#endif
} CELL;
//---------------------------------------------------------------------------
//o̓obt@^`
//---------------------------------------------------------------------------
typedef union {
	jSTANDARD_SEGMENT	seg;
	jLARGE_SEGMENT		segment;
	jTC					tc;
	CELL				cell;
	jB					buf[];
} HEADER;
#pragma option -b
//---------------------------------------------------------------------------
//s`cXg[IuWFNg
//---------------------------------------------------------------------------
class TadStream
{
	private:
    	//CONSTANT
    	#define TRON_ESC		(jUB)0xFF	//gGXP[v
		#define BASE_COLORS		256         //J[pbg{
        #define BASE_PAT_SIZE	16			//p^[TCY{
        #define	DUMMY_TCODE		(jTC)(0x2121)	//_~[TRON CODE(JPN)
        #define SYS_NEST		0			//VXelXgx
		#define SYS_PAT			1000		//VXep^[idJnԍ
        #define PAT_MIN_SIZE	128			//p^[TCYiŏۏlj
		//#define fude_chsz 		(16)		//̕WTCY
        //#define LINE_MASK_SIZE	(8)			//}XNTCY
        //#define DEV_NAME_SIZE	(11)		//foCX

        bool _create;						//H
        TImage*	_screen;					//`XN[
        AnsiString file_name;				//t@C
        //TAD read control
    	TMemoryStream *ms;					//ʐgobt@
        long access_size;					//ǂݐTCY
    	jUW now_offset;						//݂̃ItZbg
        jUW last_offset;					//ÕItZbg
        jUW body_offset;					//tⳋN_ItZbg
        jUW next_seg;						//̉ϒZOgItZbg
        jUW last_seg;						//ỎϒZOgItZbg
        jUW vcount;							//Œ蒷ZOgJEgij
        jUW segment_size;					//݂̉ϒZOgTCY
        jUW fusen_size;						//݂̉ϒZOg̃TCY
        HEADER	*head;						//cell̃AhX
        char *body;							//ϒZOg̃{fBAhX
        int _nest;							//́E}`̃lXgx(++,--)

        TadPropertyStack	_tad_stack;		//ǗX^bN
        DisplayPrimitive*	_dp;			//x[XfBXvCv~eBuIuWFNg
        Graphics::TBitmap	*_pat_bmp;		//pattern gid(bmp canvas)
        DisplayPrimitive*	_pat_dp;		//FpatternworkfBXvCv~eBu
        jUB*				_mask;			//Fpattern maskworkz
        BFont				_bfont;			//asqnmtHgNX

        //display primitive property
        //p^[Ǘ
        TImageList *_patterns;				//p^[ǗXg
        TadId<jTF_MASK>	_mask_id_table;		//}XNIDe[uIuWFNg
        TadId<jPATTERN>	_pat_id_table;		//p^[IDe[uIuWFNg


        jH			fig_height;				//͒̐}`

        //`


        //private methods
        jUW FusenSize(void) { return fusen_size; }
        int Nest(void) { return _nest; }
        void PushNest(void) { _nest++; }
        void PopNest(void) { _nest--; }
        void __fastcall clr_ipat( jPAT *pat, TColor c );

        void __fastcall create_system_mask(void);
		void __fastcall create_system_pattern(void);
		bool __fastcall cre_sys_pat( int col_id, int mask_id );
        jPATTERN* __fastcall get_sys_pat( int col_id );
        void __fastcall create_colors(void);
        jTC __fastcall now_TC(void);

        void next_segment(void);
        void last_segment(void);
        void __fastcall init_control_val(void);
        bool discover_TRONesc(void);
        void __fastcall get_length(void);
        bool read_cell(void);
        void __fastcall read_varseg(void);
        bool __fastcall select_tad(void);
        char* __fastcall offsetFromBody( int offset );
        void __fastcall read_TS_FDEF(void);
        void __fastcall read_TF_PATTERN(void);
        void __fastcall read_TF_MASK(void);
        void __fastcall read_TF_COLOR(void);
        void __fastcall read_TF_MODIFY(void);
        //void __fastcall read_TF_CORD(void);
		void __fastcall read_TS_FATTR(void);
        void __fastcall read_TS_FPRIM(void);
        void __fastcall read_LINE(void);
        void __fastcall read_RECT(void);
        void __fastcall read_RRECT(void);
        void __fastcall read_OVAL(void);
        void __fastcall read_SEC(void);
        void __fastcall read_CHORD(void);
        void __fastcall read_ARC(void);
        void __fastcall read_POLYGON(void);
        void __fastcall read_POLYLINE(void);
        void __fastcall read_SPLINE(void);
        void __fastcall read_TS_TSTYLE(void);
        void __fastcall read_TT_STYLE_on( int sNo );
        void __fastcall read_TT_STYLE_off(int sNo);
        void __fastcall read_TS_TFONT(void);
        void __fastcall read_TT_COLOR(void);
        void __fastcall read_TT_CGAP(void);
        void __fastcall read_TT_RATIO(void);
        void __fastcall read_TT_SIZE(void);
        void __fastcall read_TT_FONT(void);
        void __fastcall read_TT_FATR(void);
        void __fastcall read_TS_TRULER(void);
        void __fastcall read_TT_ALIGN(void);
        void __fastcall read_TT_LGAP(void);
        void __fastcall read_TT_FORM(void);
        void __fastcall read_TS_TPAGE(void);
        void __fastcall read_TS_TATTR(void);
        void __fastcall read_TS_FIG(void);
        void __fastcall read_TS_FIGEND(void);
        void __fastcall read_TS_TEXT(void);
        void __fastcall read_TS_TEXTEND(void);
		void __fastcall read_TS_IMAGE(void);

		void create( TImage *img, TImageList *pats, TImageList *chars, TFont *fnt, TFont *hfnt );
        void destroy(void);
        //jH pat_hsize();
        //jH pat_vsize();
        void __fastcall preread_varseg(void);
        void __fastcall preread_TS_FDEF(void);
        bool __fastcall preselect_tad(void);
        bool __fastcall preread_tad(void);
        void __fastcall init_gdev( jGID gid );
        void __fastcall init_gchstr(void);
        void __fastcall set_spec_size(void);

        bool __fastcall new_line( TadProperty *pr, jRECT r, bool onoff );
        void __fastcall draw_TSTYLE( TadProperty *pr, int shushoku );
        void __fastcall page_new_line( TadProperty *pr );
        void __fastcall tstyle_new_line( TadProperty *pr, bool onoff );
        int  __fastcall judge_TRONcode( jTC ch );
        void __fastcall judge_CONTROL( TadProperty *pr, jTC ch );
        void __fastcall read_tcode(void);

    public:
    	TadStream();
        TadStream( TImage *img,TImageList *pats, TImageList *chrs, TFont *fnt, TFont *hfnt );
        ~TadStream();
        bool Check(void) { return _create; }
        void __fastcall load(AnsiString FileName);
    	void __fastcall read_tad(void);
        void __fastcall clear_screen(void);
        void __fastcall Print(void);
		void __fastcall SaveToFile( AnsiString name );
        void __fastcall CopyToTray(void);
        void __fastcall setHojokanji(TFont *hojo);

};
#endif





