//---------------------------------------------------------------------------
//
//	  y TAD viewer for Windows z
//    TAD stream library
//	  JJ,micropower,HigashiHiroshima City,1997
//
//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#include <vcl\Clipbrd.hpp>
#include "readtad.h"
#pragma nopackwarning
//#include "taddata.h"
jTF_MASK *copy_system_mask( int id );
//---------------------------------------------------------------------------
// RXgN^
//---------------------------------------------------------------------------
TadStream::TadStream()
{
	_pat_bmp=NULL;
    _mask=NULL;
	create( NULL, NULL, NULL, NULL, NULL );
}
//---------------------------------------------------------------------------
// RXgN^
//---------------------------------------------------------------------------
TadStream::TadStream( TImage *img, TImageList *pats, TImageList *chrs, TFont *fnt, TFont *hfnt )
{
	_pat_bmp=NULL;
    _mask=NULL;
	create( img, pats, chrs, fnt, hfnt );
}
//---------------------------------------------------------------------------
// Jn
//---------------------------------------------------------------------------
void TadStream::create( TImage *img, TImageList *pats, TImageList *chrs, TFont *fnt, TFont *hfnt )
{
    file_name="";
	ms=new TMemoryStream;
    if( ms == NULL )
    {
    	_create=false;
        return;
    }
    init_control_val();
    jPARAM param;
    param.gid=img->Canvas;
    param.screenImage=_screen=img;
    param.patImageList=pats;
    param.charImageList=chrs;
    param.screenFont=fnt;
    param.hojokanji=hfnt;
    _dp=new DisplayPrimitive( &param );
    if( _dp == NULL )
    {
    	_create=false;
        return;
    }
    if( !_dp->Check() )
    {
    	_create=false;
        return;
    }
    if( _pat_bmp != NULL )
    {
    	delete _pat_bmp;
        _pat_bmp=NULL;
    }
    if( _mask != NULL )
    {
    	delete _mask;
        _mask=NULL;
    }
    //Fp^[摜
    _pat_bmp=new Graphics::TBitmap;
    if( _pat_bmp == NULL )
    {
    	_create=false;
        return;
    }
    _pat_bmp->Width=(int)PAT_MIN_SIZE;
    _pat_bmp->Height=(int)PAT_MIN_SIZE;
    //pattern dp generate
    param.gid=_pat_bmp->Canvas;
    _pat_dp=new DisplayPrimitive( &param );
    if( _pat_dp == NULL )
    {
    	_create=false;
        return;
    }
    if( !_pat_dp->Check() )
    {
    	_create=false;
        return;
    }
    //mask bytes generate
    _mask=new jUB [ (( PAT_MIN_SIZE + 15 ) / 16 ) * PAT_MIN_SIZE ];
    if( _mask == NULL )
    {
    	_create=false;
        return;
    }
    _create=true;
}
//---------------------------------------------------------------------------
// VXe}XN쐬B
//---------------------------------------------------------------------------
void __fastcall TadStream::create_system_mask(void)
{
	_mask_id_table.Append( SYS_NEST, 2, copy_system_mask( 2 ) );
	_mask_id_table.Append( SYS_NEST, 3, copy_system_mask( 3 ) );
	_mask_id_table.Append( SYS_NEST, 4, copy_system_mask( 4 ) );
	_mask_id_table.Append( SYS_NEST, 5, copy_system_mask( 5 ) );
	_mask_id_table.Append( SYS_NEST, 6, copy_system_mask( 6 ) );
	_mask_id_table.Append( SYS_NEST, 7, copy_system_mask( 7 ) );
}
//---------------------------------------------------------------------------
jTF_MASK *system_mask( int id );	//from fdef.cpp
//---------------------------------------------------------------------------
// VXeׂp^[𐶐B
//---------------------------------------------------------------------------
bool __fastcall TadStream::cre_sys_pat( int col_id, int mask_id )
{
	jPATTERN patdef;
   	patdef.spat.kind=0;
    patdef.spat.hsize=BASE_PAT_SIZE;
    patdef.spat.vsize=BASE_PAT_SIZE;
    patdef.spat.fgcol=col_id;
    patdef.spat.bgcol=jWHITE;
    jTF_MASK *tf_mask=system_mask( mask_id );
   	patdef.spat.mask=tf_mask->mask;
    jPAT* inner_pat;
    jW size;
    jERR result=_dp->gcre_pat( &patdef, NULL, &inner_pat, &size );
    if( result >= 0 )
    {
	   	jPATTERN *xpat=new jPATTERN;
        xpat->ipat.kind=2;
        xpat->ipat.hsize=BASE_PAT_SIZE;
        xpat->ipat.vsize=BASE_PAT_SIZE;
        xpat->ipat.pat=(jUB *)inner_pat;
        _pat_id_table.Append( SYS_NEST, (jUH)( SYS_PAT + col_id ), xpat );
		return ( _pat_id_table.Hit( SYS_NEST, (jUH)( SYS_PAT + col_id )) != NULL );
    }
	else
		return false;
}
//---------------------------------------------------------------------------
// VXep^[쐬B
//---------------------------------------------------------------------------
void __fastcall TadStream::create_system_pattern(void)
{
	for( int i=0 ; i < 16 ; i++ )
		cre_sys_pat( i, F100V0 );
}
//---------------------------------------------------------------------------
// VXeׂp^[ԂB
//---------------------------------------------------------------------------
jPATTERN* __fastcall TadStream::get_sys_pat( int col_id )
{
	return _pat_id_table.Hit( SYS_NEST, (jUH)( SYS_PAT + col_id ) );
}
//---------------------------------------------------------------------------
//  n
//---------------------------------------------------------------------------
void TadStream::destroy(void)
{
//	if( !_create )
//    	return;
    file_name="";
    init_control_val();
    if( ms != NULL )
    {
		delete ms;
        ms=NULL;
    }
    if( _dp != NULL )
    {
    	delete _dp;
        _dp=NULL;
    }
    if( _pat_bmp != NULL )
    {
    	delete _pat_bmp;
        _pat_bmp=NULL;
    }
    if( _mask != NULL )
    {
    	delete _mask;
        _mask=NULL;
    }
    _create=false;
}
//---------------------------------------------------------------------------
// fXgN^
//---------------------------------------------------------------------------
TadStream::~TadStream()
{
	destroy();
}
//---------------------------------------------------------------------------
// `XN[NAB
//---------------------------------------------------------------------------
void __fastcall TadStream::clear_screen(void)
{
    _screen->Canvas->Brush->Style=bsSolid;
    _screen->Canvas->Brush->Color=clWhite;
    _screen->Canvas->Pen->Style=psSolid;
    _screen->Canvas->Pen->Color=clWhite;
	_screen->Canvas->Rectangle( _screen->Left, _screen->Top, _screen->Left + _screen->Width, _screen->Top + _screen->Height );
}
//---------------------------------------------------------------------------
// t@Cis`c僌R[hj[h
//---------------------------------------------------------------------------
void __fastcall TadStream::load( AnsiString FileName )
{
	file_name=FileName;
    if( ms != NULL )
    {
    	delete ms;
		ms=new TMemoryStream;
    	if( ms == NULL )
    	{
    		_create=false;
        	return;
        }
    }
	ms->LoadFromFile( FileName );
    //access size set
    if( ms->Size < (long)sizeof(jTC) )
    	access_size=0;
    else
    	access_size=ms->Size - (long)sizeof(jTC);
    if( access_size < 0 )
    	access_size=0;
}
//---------------------------------------------------------------------------
//̃ZOgiItZbgݒj
//---------------------------------------------------------------------------
inline void TadStream::next_segment(void)
{
	now_offset=next_seg;
}
//---------------------------------------------------------------------------
//ÕZOgiItZbgݒj
//---------------------------------------------------------------------------
inline void TadStream::last_segment(void)
{
	now_offset=last_seg;
}
//---------------------------------------------------------------------------
//s`cϒZOg̒𓾂
//---------------------------------------------------------------------------
void __fastcall TadStream::get_length(void)
{
	//Œ蒷ZOgijZ
	next_seg += vcount * (int)sizeof(jTC);
	//ÕZOg̈ʒuޔ
	last_seg = next_seg;
    //ZOgTCYvZƃ{fBAhX̌vZ
	if ( head->segment.length == (jUH)0xFFFF )
    {
		segment_size= 8 + head->segment.ext_length;
        body=(char *)( (char *)ms->Memory + last_offset + sizeof(jLARGE_SEGMENT));
        body_offset=last_offset + sizeof(jLARGE_SEGMENT);
        fusen_size=head->segment.ext_length;
    }
	else
    {
		segment_size= 4 + head->segment.length;
        body=(char *)( (char *)ms->Memory + last_offset + sizeof(jSTANDARD_SEGMENT));
        body_offset=last_offset + sizeof(jSTANDARD_SEGMENT);
        fusen_size=head->segment.length;
    }
	//̃ZOgʒuvZ
	next_seg += segment_size;
	//Œ蒷ZOg񐔃NA
	vcount=0;
}
//---------------------------------------------------------------------------
//tⳋN_offset̃AhXԂB
//---------------------------------------------------------------------------
char* __fastcall TadStream::offsetFromBody( int offset )
{
	return (char *)( (char *)ms->Memory + body_offset + offset );
}
//---------------------------------------------------------------------------
//Œ蒷ZOgijǂݏo
//---------------------------------------------------------------------------
inline bool TadStream::read_cell(void)
{
    //TCY`FbNiŜ=܂߂j
    if( (long)now_offset >= access_size )
    	return false;
	//wb__AhXZbgiMemory:N_,now_ptr:ItZbg̑Έʒuwj
	head=(HEADER *)( (jB *)ms->Memory + now_offset );
	//ItZbgҔ
    last_offset=now_offset;
    now_offset+=(jUW)sizeof(jTC);
    return true;
}
//---------------------------------------------------------------------------
// read_cellA݂TCODEԂB
//---------------------------------------------------------------------------
jTC __fastcall TadStream::now_TC(void)
{
	jTC *tc=(jTC *)( (jB *)ms->Memory + last_offset );
	return *tc;
}
//---------------------------------------------------------------------------
//s`cGXP[v
//---------------------------------------------------------------------------
inline bool TadStream::discover_TRONesc(void)
{
	return( ( head->segment.tron_esc == TRON_ESC ) &&
    	    ( head->segment.segment_id >= (jUB)0x80) && ( head->segment.segment_id <= (jUB)0xFE ) );
}
//---------------------------------------------------------------------------
//ϒZOgꍇ
//---------------------------------------------------------------------------
void __fastcall TadStream::read_varseg(void)
{
	switch( head->segment.segment_id )
	{
////	case jTS_INFO:			read_TS_INFO();		break;	//Ǘ
		case jTS_TEXT:			read_TS_TEXT();		break;	//͊Jn
		case jTS_TEXTEND:		read_TS_TEXTEND();	break;	//͏I
		case jTS_FIG:			read_TS_FIG();		break;	//}`Jn
		case jTS_FIGEND:		read_TS_FIGEND();	break;	//}`I
		case jTS_TATTR:			read_TS_TATTR();	break;	//t
		case jTS_TRULER:		read_TS_TRULER();	break;	//s
		case jTS_TFONT:			read_TS_TFONT();	break;	//tHg
		case jTS_TPAGE:			read_TS_TPAGE();	break;	//͊t
		case jTS_FDEF:			read_TS_FDEF();		break;	//f[^`
		case jTS_FATTR:			read_TS_FATTR();	break;	//}`C
		case jTS_TSTYLE:		read_TS_TSTYLE();	break;	//C
		case jTS_IMAGE:			read_TS_IMAGE();	break;	//摜
	      case jTS_FPRIM:		read_TS_FPRIM();	break;	//}`vf
		default: break;
	}
    //dump();
	//̃ZOgʒuZbgiwb_ǂݏoɂK{j
	next_segment();
	//NAidvj
	vcount=0;
}
//---------------------------------------------------------------------------
// s`cZOgEZOgƂ̏֐iP[vj
//---------------------------------------------------------------------------
bool __fastcall TadStream::select_tad(void)
{
    if( !read_cell() )
    	return false;
 	if ( discover_TRONesc() )
	{
		//s`cϒZOg
		get_length();
		read_varseg();	//ZOgꍇ
	}
	else
	{
		//s`cŒ蒷ZOg
		read_tcode();
		vcount++;		//JEg
	}
	return true;		//s
}
//---------------------------------------------------------------------------
//ǂ݁FϒZOgꍇ
//---------------------------------------------------------------------------
void __fastcall TadStream::preread_varseg(void)
{
	switch( head->segment.segment_id )
	{
		case jTS_TEXT:			PushNest();			break;	//͊Jn
		case jTS_TEXTEND:		PopNest();			break;	//͏I
		case jTS_FIG:			PushNest();			break;	//}`Jn
		case jTS_FIGEND:		PopNest();			break;	//}`I
		case jTS_FDEF:			preread_TS_FDEF();	break;	//f[^`
		default: break;
	}
	//̃ZOgʒuZbgiwb_ǂݏoɂK{j
	next_segment();
	//NAidvj
	vcount=0;
}
//---------------------------------------------------------------------------
// s`cZOgEZOgƂ̏֐iP[vj
//---------------------------------------------------------------------------
bool __fastcall TadStream::preselect_tad(void)
{
    if( !read_cell() )
    	return false;
 	if ( discover_TRONesc() )
	{
		//s`cϒZOg
		get_length();
		preread_varseg();	//ZOgꍇ
	}
	else
	{
		//s`cŒ蒷ZOg
		//read_tcode();
		vcount++;		//JEg
	}
	return true;		//s
}
//---------------------------------------------------------------------------
//s`cϐ
//---------------------------------------------------------------------------
void __fastcall TadStream::init_control_val(void)
{
	next_seg=0;
	last_seg=0;
	vcount=0;
	segment_size=0;
    fusen_size=0;
    now_offset=last_offset=0;
    body_offset=0;
    _nest=0;
    fig_height=0;	//Ƃ肠
}
//---------------------------------------------------------------------------
//s`cOǂݎ
//---------------------------------------------------------------------------
bool __fastcall TadStream::preread_tad(void)
{
	bool success;
    if( _dp->gini_env() < 0 )
    	return false;
    if( ms->Size == 0 )
    	return false;
    _mask_id_table.Clear();
    _pat_id_table.Clear();
    create_system_mask();
    create_system_pattern();
    init_control_val();
	do {
		success=preselect_tad();
	} while ( success );
    return true;
}
//---------------------------------------------------------------------------
//s`cǂݎ
//---------------------------------------------------------------------------
void __fastcall TadStream::read_tad(void)
{
	bool success;
    if( !_create )
    	return;
    if( !preread_tad() )
    	return;
    init_control_val();
	do {
		success=select_tad();
	} while ( success );
}
//---------------------------------------------------------------------------
//
//---------------------------------------------------------------------------
void __fastcall TadStream::Print(void)
{
	if( !_create )
    	return;
    Printer()->BeginDoc();
    	Printer()->Canvas->Draw( 0,0, _screen->Picture->Bitmap );
    Printer()->EndDoc();
}
//---------------------------------------------------------------------------
// ʕۑ
//---------------------------------------------------------------------------
void __fastcall TadStream::SaveToFile( AnsiString name )
{
	if( !_create )
    	return;
	_screen->Picture->Bitmap->SaveToFile( name );
}
//---------------------------------------------------------------------------
// ʃg[iNbv{[hj֕ۑ
//---------------------------------------------------------------------------
void __fastcall TadStream::CopyToTray(void)
{
	if( !_create )
    	return;
    Clipboard()->Assign( _screen->Picture->Bitmap );
}
//---------------------------------------------------------------------------
#pragma option -a1
#pragma nopackwarning
//---------------------------------------------------------------------------
//摜ZOg`
//---------------------------------------------------------------------------
void __fastcall TadStream::read_TS_IMAGE(void)
{
    TadProperty *pr=_tad_stack.Tos();
    if( pr == NULL )
    	return;
	jIMAGESEG *img;
    img=(jIMAGESEG *)body;
    //k`͖T|[g
    if( img->compac != jNOCOMPAC )
    	return;
    jH mode;
    if( ( img->color >> 7 ) & 0x0001 )
    	mode=jG_XOR;	//]
    else
    	mode=jG_STORE;
    //摜ŗLJ[}bvݒ
    if( img->cinfo[0] != 0 )
    {
    	jCOLORVAL *cv;
        cv=(jCOLORVAL *)((char *)(ms->Memory) + body_offset + (int)(( img->cinfo[2] << 16 ) | img->cinfo[3] ));
    	pr->DP()->gset_col( 0, cv, (jH)( img->cinfo[0] / sizeof(jCOLORVAL)));
    }
    jC_BITMAP cbmp;
    cbmp.compac = img->compac;
    cbmp.bmp.planes	 =img->planes;
    cbmp.bmp.pixbits =img->pixbits;
    cbmp.bmp.rowbytes=img->rowbytes;
    cbmp.bmp.bounds	 =img->bounds;
    for( int i=0 ; i < cbmp.bmp.planes ; i++ )
    {
    	cbmp.bmp.baseaddr[i]=(jUB *)( (char* )(ms->Memory) + body_offset + img->base_off[i] );
    } //for i
    //摜̃}XN
    jBITMAP mbmp;
    jGSCAN *mask;

    if( img->mask == 0 )
    	mask=NULL;
    else
    {
        mbmp.planes  =img->planes;
        mbmp.pixbits =img->pixbits;
        mbmp.rowbytes=img->rowbytes;
        mbmp.bounds  =img->bounds;
        for( int i=0 ; i < mbmp.planes ; i++ )
        {
        	mbmp.baseaddr[i]=(jUB *)( (char* )(ms->Memory) + body_offset + img->mask );
        } //for i
        if( pr->DP()->gcre_msk( &mbmp, &mask ) < 0 )
        	mask=NULL;
	}
    //g
    if( img->extlen != 0 )
    {
    	jIMAGE_EXT_BGC* ext=(jIMAGE_EXT_BGC *)((char *)(ms->Memory) + body_offset + img->extend );
        //摜̔wiFw
        if( ext->ext_id == 0 && ext->len == 4 )
        {
        	jPATTERN pat;
            pat.spat.kind=0;
            pat.spat.hsize=pr->DP()->pat_size_x();
            pat.spat.vsize=pr->DP()->pat_size_y();
            pat.spat.fgcol=ext->bgcol;
            pat.spat.bgcol=jBLACK;
            jTF_MASK *tf_mask=copy_system_mask( F100V0 );
            pat.spat.mask=tf_mask->mask;
    		pr->DP()->gfil_rec( img->view, &pat, img->slope, jG_STORE );
        } //if ext->ext_id
    } //if img->extlen
    //rbg}bv`
	pr->DP()->grst_bmp( &img->view, &(cbmp.bmp), &img->draw, mask, mode );
    //}XN
    pr->DP()->grel_msk( &mask );
}
//---------------------------------------------------------------------------
//⏕tHg؂ւ
//---------------------------------------------------------------------------
void __fastcall TadStream::setHojokanji(TFont *hojo)
{
    _dp->setHojokanji(hojo);
}








