//---------------------------------------------------------------------------
//	  y TAD viewer for Windows z
//    KtHg`
//    draw GrayScaled fonts
//	  JJ,micropower,HigashiHiroshima City,2001
//
//---------------------------------------------------------------------------
#include "grayfont.h"
FIXED DFix(double d )
{
    long l;
    l=(long)(d*65536L);
    return *(FIXED *)&l;
}
//---------------------------------------------------------------------------
#include "math.h"
#define RAD(x) ((x) * 3.1415927 / 180)
//---------------------------------------------------------------------------
// RXgN^
//---------------------------------------------------------------------------
GrayScaleFont::GrayScaleFont()
{
    hFont=NULL;
    m2.eM11=DFix(cos(RAD(0)));
    m2.eM12=DFix(sin(RAD(0)));
    m2.eM21=DFix(-sin(RAD(0)));
    m2.eM22=DFix(cos(RAD(0)));
    _bm=new Graphics::TBitmap;
    colors=256;
    pixel_bytes=1;
    bm=new TMemoryStream;
    for( int i=0 ; i < 256 ; i++ )
    {
        _rgb[i].rgbBlue=255;
        _rgb[i].rgbGreen=255;
        _rgb[i].rgbRed=255;
        _rgb[i].rgbReserved=0;
    } //for i
    setSrcTStream();
    _bm->LoadFromStream( bm );
    src=bm;
    bm=new TMemoryStream;
}
//---------------------------------------------------------------------------
//  fXgN^
//---------------------------------------------------------------------------
GrayScaleFont::~GrayScaleFont()
{

    ShowMessage("end GrayScaleFont");

    delete _bm;
    delete bm;
    delete src;
}
//---------------------------------------------------------------------------
// bmp摜wb_TCYԂB
//---------------------------------------------------------------------------
inline int GrayScaleFont::get_bmp_header_size(void)
{
	return ( sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER) + sizeof(RGBQUAD) * colors );
}
//---------------------------------------------------------------------------
// bmp摜rbg}bṽTCYԂB
//---------------------------------------------------------------------------
inline int GrayScaleFont::get_bmp_size( int width, int height )
{
	return (( width * pixel_bytes + 3 ) / 4 ) * 4 * height;
}
//---------------------------------------------------------------------------
// width,heightTCY̓C[Wi摜j̑STCYԂB
//---------------------------------------------------------------------------
inline int GrayScaleFont::get_bmp_allSize( int width, int height )
{
//	return ( sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER) + sizeof(RGBQUAD) * colors + ((width + 31 ) / 32 ) * 32 * height * pixel_bytes );
	return ( sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER) + sizeof(RGBQUAD) * colors + get_bmp_size( width, height ) );
}
//---------------------------------------------------------------------------
//`rbg}bvwb_쐬
//---------------------------------------------------------------------------
void GrayScaleFont::set_bitmapHeader( int width, int height )
{
    bm->SetSize( get_bmp_allSize( width, height ) );
    if( bm->Size < get_bmp_allSize( width, height ) )
    	return;
	BITMAPFILEHEADER *bmfh=(BITMAPFILEHEADER *)( bm->Memory );
    bmfh->bfType=(WORD)( 'B' | ( 'M' << 8 ) );
    bmfh->bfSize=(DWORD)( get_bmp_allSize( width, height ) );
    bmfh->bfReserved1=0;
    bmfh->bfReserved2=0;
    bmfh->bfOffBits=(DWORD)( get_bmp_header_size() );
	BITMAPINFOHEADER *bmih=(BITMAPINFOHEADER *)((char *)(bm->Memory) + sizeof(BITMAPFILEHEADER) );
	bmih->biSize=sizeof(BITMAPINFOHEADER);
	bmih->biWidth=(DWORD)width;
	bmih->biHeight=(DWORD)height;
	bmih->biPlanes=1;
    if( pixel_bytes == 3 )
    	bmih->biBitCount=24;
    else
        bmih->biBitCount=8;
	bmih->biCompression=BI_RGB;
    bmp_rowbytes=(( width * pixel_bytes + 3 ) / 4 ) * 4;	//4oCgP
	bmih->biSizeImage=bmp_rowbytes * height * pixel_bytes;
	bmih->biXPelsPerMeter=0;
	bmih->biYPelsPerMeter=0;
    if( pixel_bytes == 3 )
    {
    	bmih->biClrUsed=0;
        bmih->biClrImportant=0;
    }
    else
    //if( pixel_bytes == 1 )
    {
		bmih->biClrUsed=256;
		bmih->biClrImportant=256;
    }
}
//---------------------------------------------------------------------------
//J[pbgϊZbg
//---------------------------------------------------------------------------
void GrayScaleFont::set_rgb( RGBQUAD *rq )
{
	RGBQUAD *bmp_rgb=(RGBQUAD *)( (char *)(bm->Memory) + (int)sizeof(BITMAPFILEHEADER) + (int)sizeof(BITMAPINFOHEADER) );
    memcpy( (char *)bmp_rgb, (char *)rq, sizeof(RGBQUAD) * colors );
}
//---------------------------------------------------------------------------
//KtHgrbg}bvrbg}bvXg[쐬
//---------------------------------------------------------------------------
void GrayScaleFont::setTStream(GLYPHMETRICS* gm,LPBYTE lpBuf,size_t sz) //,TColor c)
{
    set_bitmapHeader(gm->gmBlackBoxX,gm->gmBlackBoxY);
    bm->SetSize( get_bmp_allSize(gm->gmBlackBoxX,gm->gmBlackBoxY) );
    //APIœnꂽrbg}bv̏㉺]Ă̂
    char *srcPtr;
    char *dstPtr;
    for(unsigned int row=0 ; row < gm->gmBlackBoxY ; row++ )
    {
        dstPtr=(char *)((char *)bm->Memory + get_bmp_header_size() + (gm->gmBlackBoxY - row - 1 ) * bmp_rowbytes );
        srcPtr=(char *)(&lpBuf[bmp_rowbytes*row]);
        memcpy(dstPtr,srcPtr,bmp_rowbytes);
    } //for row
    //O[XP[őlo
    unsigned int colValMax=0;
    unsigned int ptr;
    for( ptr=0 ; ptr < sz ; ptr++ )
    {
        if( lpBuf[ptr] != 0 )
        {
            if( (unsigned int)lpBuf[ptr] > colValMax )
                colValMax=(unsigned int)lpBuf[ptr];
        }
    } //for ptr
    //J[pbgݒ
    _rgb[0].rgbBlue=255;
    _rgb[0].rgbGreen=255;
    _rgb[0].rgbRed=255;
    _rgb[0].rgbReserved=0;
    for( ptr=1 ; ptr < 256 ; ptr++ )
    {
        if( ptr > colValMax )
        {
            _rgb[ptr].rgbBlue=255;
            _rgb[ptr].rgbGreen=255;
            _rgb[ptr].rgbRed=0;
            _rgb[ptr].rgbReserved=0;
        }
        else
        {
            jBYTE gray=(jBYTE)((255*(colValMax-ptr))/colValMax);
            _rgb[ptr].rgbBlue=gray;
            _rgb[ptr].rgbGreen=gray;
            _rgb[ptr].rgbRed=gray;
            _rgb[ptr].rgbReserved=0;

        } //if
    } //for ptr
    set_rgb(_rgb);
}
//---------------------------------------------------------------------------
//wî߂̃rbg}bvXg[쐬
//---------------------------------------------------------------------------
void GrayScaleFont::setSrcTStream(void)
{
    set_bitmapHeader(256,256);
    bm->SetSize( get_bmp_allSize(256,256) );
	char *dst=(char *)( (char *)bm->Memory + get_bmp_header_size() );
    setmem(dst,bmp_rowbytes * 256 * pixel_bytes,0);
    set_rgb(_rgb);
}
//---------------------------------------------------------------------------
//KtHg`悷B
//---------------------------------------------------------------------------
void _fastcall GrayScaleFont::TextOut(TCanvas* src,Graphics::TBitmap* bch,int x,int y,char *str)
{
    UINT ch;
    HFONT hOldFont;
    hFont=CreateFont( bch->Height,0,0,0,FW_NORMAL,
                            FALSE,FALSE,FALSE,
                            bch->Canvas->Font->Charset,
                            OUT_DEFAULT_PRECIS,
                            CLIP_DEFAULT_PRECIS,
                            DEFAULT_QUALITY,
                            DEFAULT_PITCH,
                            (LPCTSTR)bch->Canvas->Font->Name.c_str());
    hOldFont=SelectObject(_bm->Canvas->Handle,hFont);
    if( str[1] == NULL )
        ch=(UINT)str[0];
    else
        ch=(UINT)((0x0000FF00 & (UINT)(str[0]<<8)) | ( 0x000000FF & (UINT)str[1]));
    dwRet=GetGlyphOutline( _bm->Canvas->Handle,ch,GGO_GRAY8_BITMAP,&gm,0,NULL,&m2);
    lpBuf=(LPBYTE)GlobalAlloc(GPTR,dwRet);
    GlobalLock(lpBuf);
    GetGlyphOutline(_bm->Canvas->Handle,ch,GGO_GRAY8_BITMAP,&gm,dwRet,lpBuf,&m2);
    setTStream(&gm,lpBuf,dwRet);
    //摜
    Graphics::TBitmap *tbmp=new Graphics::TBitmap;

/*
    char msg[100];
    int fail=0;
    if( hFont == NULL )
        fail=1;
    if( tbmp == NULL )
        sprintf(msg,"ch=%c dwRet=%d tbmp=NULL fail=%d",ch,dwRet,fail );
    else
        sprintf(msg,"ch=%c dwRet=%d x=%d y=%d h=%d w=%d fail=%d str[0]=%X,str[1]=%X UINT=%d ch=%X",ch,dwRet,gm.gmBlackBoxX,gm.gmBlackBoxY,bch->Height,bch->Width,fail,str[0],str[1],sizeof(UINT),ch );
    ShowMessage(msg);
*/


    if( tbmp == NULL )
    	return;
    tbmp->LoadFromStream( bm );
    //tbmp->Transparent = true;
    //tbmp->TransparentMode=tmFixed;
    //tbmp->TransparentColor = clRed;

    //debug
    //tbmp->SaveToFile("d:\\tad\\xxx.bmp");
    //bm->SaveToFile("d:\\tad\\yyy.bmp");

    TRect r=Rect(x,y,x+bch->Width,y+bch->Height);
    src->StretchDraw( r, tbmp );
    delete tbmp;
    GlobalUnlock(lpBuf);
    GlobalFree(lpBuf);
    SelectObject(_bm->Canvas->Handle,hOldFont);
    DeleteObject( hFont );
}
