//---------------------------------------------------------------------------
//yfBXvCv~eBuz݊ }`vf`֐
//---------------------------------------------------------------------------
#include "gpi.h"
#include "gwork.h"
#include <stdlib.h>
//---------------------------------------------------------------------------
// API:_̏Ԃ̎o Test Point
//---------------------------------------------------------------------------
jERR __fastcall DisplayPrimitive::gtst_pnt( jPNT p, jWP val )
{
	CHECK_GID;
    //Nbv(0/1)lB
    TColor tc=canvas->Pixels[ (int)(p.x) ][ (int)(p.y) ];
    jCOLORVAL cv=_tcolor_colorval( &tc );
    jW value;
    gcnv_col( cv, &value );
    *val=value;
    return jEG_OK;
}
//---------------------------------------------------------------------------
// API:_̕` Draw Point
//---------------------------------------------------------------------------
jERR __fastcall DisplayPrimitive::gdra_pnt( jPNT p, jPIXVAL val, jDCM mode )
{
	CHECK_GID;
    if( _point_bmp == NULL )
    	return jEG_NOSPC;
    //`惂[hݒ
    long rop;
    convert_mode_rop( mode, rop );
    canvas->CopyMode=rop;
    //TColorBlue,Green,Red̏,COLORVAL,RGBQUADRed,Green,BluȅiԈႦȁj
    TColor col;
    if( val >= BASE_COLORS )
    {
 		_COLORVAL cv;
        cv.value=(jCOLORVAL)val;
        col=(TColor)(( cv.bitfield.b << 16 ) | ( cv.bitfield.g << 8 ) | cv.bitfield.r );
    }
    else
    {
    	col=(TColor)(( _palette[val].rgbBlue << 16 ) | ( _palette[val].rgbGreen << 8 ) | _palette[val].rgbRed );
    }
    _point_bmp->Canvas->Pixels[0][0]=col;
    canvas->Draw( (int)(p.x), (int)(p.y), _point_bmp );
    return jEG_OK;
}
//---------------------------------------------------------------------------
// API:_̃p^[` Fill Point
//---------------------------------------------------------------------------
jERR __fastcall DisplayPrimitive::gfil_pnt( jPNT p, jPATTERN *pat, jDCM mode )
{
	jRECT r;
    r.c.left=p.x;
    r.c.top=p.y;
    r.c.right=(jH)( p.x + 1 );
    r.c.bottom=(jH)( p.y + 1 );
    return gfil_rec( r, pat, (jH)0, mode );
}
//---------------------------------------------------------------------------
// src`̕widthЂƂ܂菬`dst߂B
//---------------------------------------------------------------------------
void get_short_rect( RECT &src, int width, RECT &dst )
{
	int cx=( src.left + src.right ) / 2;
    int cy=( src.top + src.bottom ) / 2;
    dst.left = src.left + width;
    dst.right = src.right - width;
    dst.top = src.top + width;
    dst.bottom = src.bottom - width;
    if( dst.left >= dst.right )
    	dst.left=dst.right=cx;
    if( dst.top >= dst.bottom )
    	dst.top=dst.bottom=cy;
}
//---------------------------------------------------------------------------
// p`(p,max_index)͂ލŏ̒`minr߂B
//---------------------------------------------------------------------------
void get_polygon_covering( POINT *p, int max_index, RECT *minr )
{
	int min_x,min_y;
    int max_x,max_y;
    min_x=max_x=p[0].x;
    min_y=max_y=p[0].y;
    if( minr == NULL )
    	return;
    if( max_index <= 0 )
    {
    	minr->left=minr->right=p[0].x;
        minr->top=minr->bottom=p[0].y;
        return;
    }
    for( int i=1 ; i <= max_index ; i++ )
    {
    	if( min_x > p[i].x )
        	min_x=p[i].x;
        if( min_y > p[i].y )
        	min_y=p[i].y;
        if( max_x < p[i].x )
        	max_x=p[i].x;
        if( max_y < p[i].y )
        	max_y=p[i].y;
    } //for
    minr->left=min_x;
    minr->top=min_y;
    minr->right=max_x;
    minr->bottom=max_y;
}
//---------------------------------------------------------------------------
// srcp`(sp,s_max)̕widthЂƂ܂菬p`(dp,s_max)߂B
//---------------------------------------------------------------------------
void get_short_polygon( POINT *sp, int s_max, int width, POINT *dp )
{
	RECT r;
    int width_x,width_y;
	get_polygon_covering( sp, s_max, &r );
    if(( width * 2 ) > ( r.right - r.left ))
    	width_x=( r.right - r.left ) / 2;
    else
    	width_x=width;
    if(( width * 2 ) > ( r.bottom - r.top ))
    	width_y=( r.bottom - r.top ) / 2;
    else
    	width_y=width;
    float rx=( r.right - r.left - width_x * 2 ) / ( r.right - r.left );
    float ry=( r.bottom - r.top - width_y * 2 ) / ( r.bottom - r.top );
    for( int i=0 ; i < s_max ; i++ )
    {
    	dp[i].x=(int)((float)( sp[i].x - r.left ) * rx ) + r.left + width_x;
        dp[i].y=(int)((float)( sp[i].y - r.top ) * ry ) + r.top + width_y;
    } //for
}
//---------------------------------------------------------------------------
// (sp,ep,width)\p`(ps,ps_max)𓾂B
// _͓_̓_Ƃ`iʏp)
//---------------------------------------------------------------------------
int get_line_polygon( POINT sp, POINT ep, int width, POINT *ps, int *ps_max )
{
	int ix=min( sp.x, ep.x );
	int iy=min( sp.y, ep.y );
	int ax=max(( sp.x + width ), ( ep.x + width ));
	int ay=max(( sp.y + width ), ( ep.y + width ));
	//horizontal line or vertical line
	if( sp.x == ep.x || sp.y == ep.y )
	{
		*ps_max=4;	//index num=4
		ps[0].x=ix;		ps[0].y=iy;
		ps[1].x=ix;		ps[1].y=ay;
		ps[2].x=ax;		ps[2].y=ay;
		ps[3].x=ax;		ps[3].y=iy;
		return 3;
	}
	//sloped line
	// x order
	POINT lp,rp;
	if( sp.x < ep.x )
	{
		lp=sp; rp=ep;
	}
	else
	{
		lp=ep; rp=sp;
	}
//    ix   ax
//   iy+----+
//     |*  /|
//     | *  |
//     | /* |
//     |/  *|
//   ay+----+
	// left point is higher than right point (normal sloped /)
	if( lp.y > rp.y )
	{
		*ps_max=6;	//index num=6
		//direction as a clock
		ps[0].x=ix;			ps[0].y=ay;
		ps[1].x=ix;			ps[1].y=ay - width;
		ps[2].x=ax - width;	ps[2].y=iy;
		ps[3].x=ax;			ps[3].y=iy;
		ps[4].x=ax;			ps[4].y=iy + width;
		ps[5].x=ix + width;	ps[5].y=ay;
	}
	else
	// right point is higher than left point (back sloped \)
	{
		*ps_max=6;	//index num=6
		ps[0].x=ix;			ps[0].y=iy;
		ps[1].x=ix + width;	ps[1].y=iy;
		ps[2].x=ax;			ps[2].y=ay - width;
		ps[3].x=ax;			ps[3].y=ay;
		ps[4].x=ax - width;	ps[4].y=ay;
		ps[5].x=ix;			ps[5].y=iy + width;
	}
    return 5;
}
//---------------------------------------------------------------------------
// (sp,ep,width)\p`(ps,ps_max)𓾂B
// _p͓_𒆐SƂ鑾width̋`iA|̒[pj
//---------------------------------------------------------------------------
int get_centerline_polygon( POINT sp, POINT ep, int width, POINT *ps, int *ps_max )
{
	int ix=min(( sp.x - width ), ( ep.x - width ));
	int iy=min(( sp.y - width ), ( ep.y - width ));
	int ax=max(( sp.x + width ), ( ep.x + width ));
	int ay=max(( sp.y + width ), ( ep.y + width ));
	//horizontal line or vertical line
	if( sp.x == ep.x || sp.y == ep.y )
	{
		*ps_max=4;	//index num=4
		ps[0].x=ix;		ps[0].y=iy;
		ps[1].x=ix;		ps[1].y=ay;
		ps[2].x=ax;		ps[2].y=ay;
		ps[3].x=ax;		ps[3].y=iy;
		return 3;
	}
	//sloped line
	// x order
	POINT lp,rp;
	if( sp.x < ep.x )
	{
		lp=sp; rp=ep;
	}
	else
	{
		lp=ep; rp=sp;
	}
//    ix   ax
//   iy+----+
//     |*  /|
//     | *  |
//     | /* |
//     |/  *|
//   ay+----+
	// left point is higher than right point (normal sloped /)
	if( lp.y > rp.y )
	{
		*ps_max=6;	//index num=6
		//direction as a clock
		ps[0].x=ix;			ps[0].y=ay;
		ps[1].x=ix;			ps[1].y=ay - width;
		ps[2].x=ax - width;	ps[2].y=iy;
		ps[3].x=ax;			ps[3].y=iy;
		ps[4].x=ax;			ps[4].y=iy + width;
		ps[5].x=ix + width;	ps[5].y=ay;
	}
	else
	// right point is higher than left point (back sloped \)
	{
		*ps_max=6;	//index num=6
		ps[0].x=ix;			ps[0].y=iy;
		ps[1].x=ix + width;	ps[1].y=iy;
		ps[2].x=ax;			ps[2].y=ay - width;
		ps[3].x=ax;			ps[3].y=ay;
		ps[4].x=ax - width;	ps[4].y=ay;
		ps[5].x=ix;			ps[5].y=iy + width;
	}
    return 5;
}
//---------------------------------------------------------------------------
// `rł邩H
//---------------------------------------------------------------------------
inline bool empty_rect( jRECT &r )
{
	return (( r.c.left >= r.c.right ) || ( r.c.top >= r.c.bottom ));
}
//---------------------------------------------------------------------------
#define SDnx		0x00990066L		//DSxn
//---------------------------------------------------------------------------
//`惂[hϊ(BTRON`惂[hWindows RX^[Iy[VR[hj
//---------------------------------------------------------------------------
/*
jW convert_mode_rop( jH mode, DWORD &rop )
{
	jW result=jEG_OK;
	switch( mode )
	{
		case jG_STORE:	rop=SRCCOPY;	break;	//S     S
		case jG_XOR:	rop=SRCINVERT;	break;	//S^D   SDx
		case jG_OR:		rop=SRCPAINT;	break;	//S|D   SDo
		case jG_AND:	rop=SRCAND;		break;	//S&D   SDa
		case jG_CPYN:	rop=NOTSRCCOPY;	break;	//~S    Sn
		case jG_XORN:	rop=SDnx;		break;	//~S^D  SDnx
		case jG_ORN:	rop=MERGEPAINT;	break;	//~S|D  SDno
		case jG_ANDN:	rop=SRCERASE;	break;	//~S&D  SDna
        default:		rop=SRCCOPY;	result=jEG_PAR;
	}
    return result;
}
*/
//---------------------------------------------------------------------------
jERR convert_mode_rop( const jH &mode, long &rop )
{
	jERR result=jEG_OK;
	switch( mode )
	{
		case jG_STORE:	rop=cmSrcCopy;		break;	//S     S
		case jG_XOR:	rop=cmSrcInvert;	break;	//S^D   SDx
		case jG_OR:		rop=cmSrcPaint;		break;	//S|D   SDo
		case jG_AND:	rop=cmSrcAnd;		break;	//S&D   SDa
		case jG_CPYN:	rop=cmNotSrcCopy;	break;	//~S    Sn
		case jG_XORN:	rop=(long)SDnx;		break;	//~S^D  SDnx
		case jG_ORN:	rop=cmMergePaint;	break;	//~S|D  SDno
		case jG_ANDN:	rop=cmSrcErase;		break;	//~S&D  SDna
        default:		rop=cmSrcCopy;		//result=jEG_PAR;
	}
    return result;
}
//---------------------------------------------------------------------------
// ̐ݒ(`LoXcv,)
//---------------------------------------------------------------------------
jW DisplayPrimitive::_set_l_atr( jLATTR attr, jH &width )
{
	_L_ATR *l_atr;
    l_atr=(_L_ATR *)&attr;
	if( l_atr->bitfield.W == 0 )
		return jEG_OK;
	canvas->Pen->Width=(int)l_atr->bitfield.W;
    width=(jH)(l_atr->bitfield.W);
	TPenStyle style;
	jW result=1;
	switch( (jH)(l_atr->bitfield.T) )
	{
		case jLN_SOLID:		style=psSolid;		break;
		case jLN_DASH:		style=psDash;		break;
		case jLN_DOT:		style=psDot;		break;
		case jLN_DDASH:		style=psDashDot;	break;
		case jLN_DDDASH:	style=psDashDotDot;	break;
		case jLN_LDASH:		style=psDash;		break; //no support
		default:			style=psSolid;	//result=jEG_NOSPT;
	}
	canvas->Pen->Style=style;
	return result;
}
//---------------------------------------------------------------------------
// `F̐}``Ŏgp錴n֐
//---------------------------------------------------------------------------
jERR __fastcall DisplayPrimitive::_gdra_lin( jPNT p1, jPNT p2, jLATTR attr, jPATTERN *pat, jDCM mode )
{
	jERR result;
    CHECK_ATTR;
	POINT _p1,_p2;
	_Pnt( p1, _p1 );
	_Pnt( p2, _p2 );
	get_line_polygon( _p1, _p2, width, _line_polygon, &_line_polygon_num );
    HRGN hSrcRgn=CreatePolygonRgn( _line_polygon, _line_polygon_num, ALTERNATE );
    if( hSrcRgn == NULL )
    	return jEG_NOSPC;
    if( !SelectClipRgn( canvas->Handle, hSrcRgn ) )
    {
    	DeleteObject( hSrcRgn );
    	return jEG_NOSPC;
    }
	result=jEG_OK;
    RECT src_r;
    get_polygon_covering( _line_polygon, _line_polygon_num - 1, &src_r );
    jRECT frame;
    _RECT( src_r, frame );
    jPAT *jpat;
    if( pat->spat.kind == 0 || pat->mpat.kind == 1 )
    {
    	int size;
    	result=gcre_pat( pat, NULL, &jpat, &size );
    }
    else
    if( pat->ipat.kind == 2 )
    	jpat=(jPAT *)pat->ipat.pat;
    else
    	result=jEG_PAR;
    if( result >= 0 )
    	tiling( frame, attr, jpat );
    DeleteObject( hSrcRgn );
	return result;
}
//---------------------------------------------------------------------------
// API:̕` Draw Line
//---------------------------------------------------------------------------
jERR __fastcall DisplayPrimitive::gdra_lin( jPNT p1, jPNT p2, jLATTR attr, jPATTERN *pat, jDCM mode )
{
	jW result;
	CHECK_GID;
	CHECK_ATTR;
	CHECK_PAT;
	CHECK_MODE;
	POINT _p1,_p2;
	_Pnt( p1, _p1 );
	_Pnt( p2, _p2 );
	get_line_polygon( _p1, _p2, width, _line_polygon, &_line_polygon_num );
    HRGN hSrcRgn=CreatePolygonRgn( _line_polygon, _line_polygon_num, ALTERNATE );
    if( hSrcRgn == NULL )
    	return jEG_NOSPC;
    if( !SelectClipRgn( canvas->Handle, hSrcRgn ) )
    {
    	DeleteObject( hSrcRgn );
    	return jEG_NOSPC;
    }
    result=jEG_OK;
    RECT src_r;
    get_polygon_covering( _line_polygon, _line_polygon_num - 1, &src_r );
    jRECT frame;
    _RECT( src_r, frame );
    jPAT *jpat;
    if( pat->spat.kind == 0 || pat->mpat.kind == 1 )
    {
    	int size;
    	result=gcre_pat( pat, NULL, &jpat, &size );
    }
    else
    if( pat->ipat.kind == 2 )
    	jpat=(jPAT *)pat->ipat.pat;
    else
    	result=jEG_PAR;
    if( result >= 0 )
    	tiling( frame, attr, jpat );
    DeleteObject( hSrcRgn );
	return result;
}
//---------------------------------------------------------------------------
// API: `̘g̕` Frame Rectangle
//---------------------------------------------------------------------------
jERR __fastcall DisplayPrimitive::gfra_rec( jRECT r, jLATTR attr, jPATTERN *pat, jDEG angle, jDCM mode )
{
	jW result;
	CHECK_GID;
	CHECK_RECT;
	CHECK_ATTR;
	CHECK_PAT;
	CHECK_MODE;
	CHECK_ANGLE;
    RECT src_r,short_r;
    _Rct( r, src_r );
    get_short_rect( src_r, width, short_r );
    HRGN hSrcRgn=CreateRectRgnIndirect( &src_r );
    if( hSrcRgn == NULL )
    	return jEG_NOSPC;
    HRGN hShortRgn=CreateRectRgnIndirect( &short_r );
    if( hShortRgn == NULL )
    {
    	DeleteObject( hSrcRgn );
    	return jEG_NOSPC;
    }
    HRGN hRgn=CreateRectRgn( 0, 0, 1, 1 );
    if( hRgn == NULL )
    {
    	DeleteObject( hSrcRgn );
        DeleteObject( hShortRgn );
        return jEG_NOSPC;
    }
    CombineRgn( hRgn, hSrcRgn, hShortRgn, RGN_DIFF );
    DeleteObject( hShortRgn );
    if( !SelectClipRgn( canvas->Handle, hRgn ) )
    {
    	DeleteObject( hSrcRgn );
    	DeleteObject( hShortRgn );
    	DeleteObject( hRgn );
    	return jEG_NOSPC;
    }
    jPAT *jpat;
    if( pat->spat.kind == 0 || pat->mpat.kind == 1 )
    {
    	int size;
    	result=gcre_pat( pat, NULL, &jpat, &size );
    }
    else
    if( pat->ipat.kind == 2 )
    	jpat=(jPAT *)pat->ipat.pat;
    else
    	result=jEG_PAR;
    if( result >= 0 )
    	tiling( r, attr, jpat );
    DeleteObject( hSrcRgn );
    DeleteObject( hShortRgn );
    DeleteObject( hRgn );
	return jEG_OK;
}
//---------------------------------------------------------------------------
// API: `̓hׂ Fill Rectangle
//---------------------------------------------------------------------------
jERR __fastcall DisplayPrimitive::gfil_rec( jRECT r, jPATTERN *pat, jDEG angle, jDCM mode )
{
	jW result;
	CHECK_GID;
	CHECK_RECT;
	CHECK_PAT;
	CHECK_MODE;
	CHECK_ANGLE;
    RECT src_r;
    _Rct( r, src_r );
    HRGN hSrcRgn=CreateRectRgnIndirect( &src_r );
    if( hSrcRgn == NULL )
    	return jEG_NOSPC;
    if( !SelectClipRgn( canvas->Handle, hSrcRgn ) )
    {
    	DeleteObject( hSrcRgn );
    	return jEG_NOSPC;
    }
    //gid->Rectangle( src_r.left, src_r.top, src_r.right, src_r.bottom );
    jPAT *jpat;
    if( pat->spat.kind == 0 || pat->mpat.kind == 1 )
    {
    	int size;
    	result=gcre_pat( pat, NULL, &jpat, &size );
    }
    else
    if( pat->ipat.kind == 2 )
    	jpat=(jPAT *)pat->ipat.pat;
    else
    	result=jEG_PAR;
    if( result >= 0 )
    	tiling( r, 0x0101, jpat );
/*
//test//
    if( result >= 0 )
    {
    	Graphics::TBitmap *bmp=new Graphics::TBitmap;
        _patterns->GetBitmap( jpat->index, bmp );
		//HBRUSH hBrush=CreatePatternBrush( bmp->Canvas->Handle );
		//HBRUSH hBrush=CreateHatchBrush( HS_BDIAGONAL, RGB(200,5,1) );
        LOGBRUSH logBrush;
        logBrush.lbStyle=(UINT)BS_PATTERN;
        logBrush.lbColor=(COLORREF)DIB_RGB_COLORS;
        logBrush.lbHatch=(LONG)bmp->MaskHandle;
        HBRUSH hBrush=CreateBrushIndirect(&logBrush);
        //HBRUSH hBrush=CreateDIBPatternBrush(bmp->MaskHandle,DIB_RGB_COLORS);
        //if( hBrush == NULL )
         //	tiling( r, 0x0101, jpat );
        HBRUSH hOldBrush=(HBRUSH)SelectObject( canvas->Handle, hBrush);
        FillRgn( canvas->Handle, hSrcRgn, hBrush );
           //gid->Rectangle( src_r.left, src_r.top, src_r.right, src_r.bottom );

        SelectObject( canvas->Handle, hOldBrush );
        DeleteObject( hBrush );
    }
*/
    DeleteObject( hSrcRgn );
	return jEG_OK;
}
//---------------------------------------------------------------------------
// API: pے`̘g̕` Frame Round Rectangle
//---------------------------------------------------------------------------
jERR __fastcall DisplayPrimitive::gfra_rrc( jRECT r, jH rh, jH rv, jLATTR attr, jPATTERN *pat, jDEG angle, jDCM mode )
{
	jW result;
	CHECK_GID;
	CHECK_RECT;
	CHECK_ROUND;
	CHECK_RHV;
	CHECK_ATTR;
	CHECK_PAT;
	CHECK_MODE;
	CHECK_ANGLE;
    RECT src_r,short_r;
    _Rct( r, src_r );
    get_short_rect( src_r, width, short_r );
    HRGN hSrcRgn=CreateRoundRectRgn( src_r.left, src_r.top, src_r.right, src_r.bottom, (int)rh, (int)rv );
    if( hSrcRgn == NULL )
    	return jEG_NOSPC;
	rrh=rrh - width;
	rrv=rrv - width;
	if( rrh < 0 )
		rrh=0;
	if( rrv < 0 )
		rrv=0;
    HRGN hShortRgn=CreateRoundRectRgn( 
						short_r.left, short_r.top, short_r.right, short_r.bottom,
						rrh, rrv );
    if( hShortRgn == NULL )
    {
    	DeleteObject( hSrcRgn );
    	return jEG_NOSPC;
    }
    HRGN hRgn=CreateRectRgn( 0, 0, 1, 1 );
    if( hRgn == NULL )
    {
    	DeleteObject( hSrcRgn );
        DeleteObject( hShortRgn );
        return jEG_NOSPC;
    }
    CombineRgn( hRgn, hSrcRgn, hShortRgn, RGN_DIFF );
    DeleteObject( hShortRgn );
    if( !SelectClipRgn( canvas->Handle, hRgn ) )
    {
    	DeleteObject( hSrcRgn );
    	DeleteObject( hShortRgn );
    	DeleteObject( hRgn );
    	return jEG_NOSPC;
    }
    //gid->Rectangle( src_r.left, src_r.top, src_r.right, src_r.bottom );
    jPAT *jpat;
    if( pat->spat.kind == 0 || pat->mpat.kind == 1 )
    {
    	int size;
    	result=gcre_pat( pat, NULL, &jpat, &size );
    }
    else
    if( pat->ipat.kind == 2 )
    	jpat=(jPAT *)pat->ipat.pat;
    else
    	result=jEG_PAR;
    jRECT frame;
    _RECT( src_r, frame );
    if( result >= 0 )
    	tiling( frame, attr, jpat );
    DeleteObject( hSrcRgn );
    DeleteObject( hShortRgn );
    DeleteObject( hRgn );
	return jEG_OK;
}
//---------------------------------------------------------------------------
// API: pے`̓hׂ Fill Round Rectangle
//---------------------------------------------------------------------------
jERR __fastcall DisplayPrimitive::gfil_rrc( jRECT r, jH rh, jH rv, jPATTERN *pat, jDEG angle, jDCM mode )
{
	jW result;
	CHECK_GID;
	CHECK_RECT;
	CHECK_ROUND;
	CHECK_RHV;
	CHECK_PAT;
	CHECK_MODE;
	CHECK_ANGLE;
    RECT src_r;
    _Rct( r, src_r );
    HRGN hSrcRgn=CreateRoundRectRgn( src_r.left, src_r.top, src_r.right, src_r.bottom,
					rrh, rrv );
    if( hSrcRgn == NULL )
    	return jEG_NOSPC;
    if( !SelectClipRgn( canvas->Handle, hSrcRgn ) )
    {
    	DeleteObject( hSrcRgn );
    	return jEG_NOSPC;
    }
    //gid->Rectangle( src_r.left, src_r.top, src_r.right, src_r.bottom );
    jPAT *jpat;
    if( pat->spat.kind == 0 || pat->mpat.kind == 1 )
    {
    	int size;
    	result=gcre_pat( pat, NULL, &jpat, &size );
    }
    else
    if( pat->ipat.kind == 2 )
    	jpat=(jPAT *)pat->ipat.pat;
    else
    	result=jEG_PAR;
    jRECT frame;
    _RECT( src_r, frame );
    if( result >= 0 )
    	tiling( frame, 0x0101, jpat );
    DeleteObject( hSrcRgn );
	return jEG_OK;
}
//---------------------------------------------------------------------------
// API: ȉ~i~j̘g̕` Frame Oval
//---------------------------------------------------------------------------
jERR __fastcall DisplayPrimitive::gfra_ovl( jRECT r, jLATTR attr, jPATTERN *pat, jDEG angle, jDCM mode )
{
	jW result;
	CHECK_GID;
	CHECK_RECT;
	CHECK_ATTR;
	CHECK_PAT;
	CHECK_MODE;
	CHECK_ANGLE;
    RECT src_r,short_r;
    _Rct( r, src_r );
    get_short_rect( src_r, width, short_r );
    HRGN hSrcRgn=CreateEllipticRgnIndirect( &src_r );
    if( hSrcRgn == NULL )
    	return jEG_NOSPC;
    HRGN hShortRgn=CreateEllipticRgnIndirect( &short_r );
    if( hShortRgn == NULL )
    {
    	DeleteObject( hSrcRgn );
    	return jEG_NOSPC;
    }
    HRGN hRgn=CreateRectRgn( 0, 0, 1, 1 );
    if( hRgn == NULL )
    {
    	DeleteObject( hSrcRgn );
        DeleteObject( hShortRgn );
        return jEG_NOSPC;
    }
    CombineRgn( hRgn, hSrcRgn, hShortRgn, RGN_DIFF );
    DeleteObject( hShortRgn );
    if( !SelectClipRgn( canvas->Handle, hRgn ) )
    {
    	DeleteObject( hSrcRgn );
    	DeleteObject( hShortRgn );
    	DeleteObject( hRgn );
    	return jEG_NOSPC;
    }
    //gid->Rectangle( src_r.left, src_r.top, src_r.right, src_r.bottom );
    jPAT *jpat;
    if( pat->spat.kind == 0 || pat->mpat.kind == 1 )
    {
    	int size;
    	result=gcre_pat( pat, NULL, &jpat, &size );
    }
    else
    if( pat->ipat.kind == 2 )
    	jpat=(jPAT *)pat->ipat.pat;
    else
    	result=jEG_PAR;
    jRECT frame;
    _RECT( src_r, frame );
    if( result >= 0 )
    	tiling( frame, attr, jpat );
    DeleteObject( hSrcRgn );
    DeleteObject( hShortRgn );
    DeleteObject( hRgn );
	return jEG_OK;
}
//---------------------------------------------------------------------------
// API: ȉ~i~j̓hׂ Fill Oval
//---------------------------------------------------------------------------
jERR __fastcall DisplayPrimitive::gfil_ovl( jRECT r, jPATTERN *pat, jDEG angle, jDCM mode )
{
	jW result;
	CHECK_GID;
	CHECK_RECT;
	CHECK_PAT;
	CHECK_MODE;
	CHECK_ANGLE;
    RECT src_r;
    _Rct( r, src_r );
    HRGN hSrcRgn=CreateEllipticRgnIndirect( &src_r );
    if( hSrcRgn == NULL )
    	return jEG_NOSPC;
    if( !SelectClipRgn( canvas->Handle, hSrcRgn ) )
    {
    	DeleteObject( hSrcRgn );
    	return jEG_NOSPC;
    }
    //gid->Rectangle( src_r.left, src_r.top, src_r.right, src_r.bottom );
    jPAT *jpat;
    if( pat->spat.kind == 0 || pat->mpat.kind == 1 )
    {
    	int size;
    	result=gcre_pat( pat, NULL, &jpat, &size );
    }
    else
    if( pat->ipat.kind == 2 )
    	jpat=(jPAT *)pat->ipat.pat;
    else
    	result=jEG_PAR;
    jRECT frame;
    _RECT( src_r, frame );
    if( result >= 0 )
    	tiling( frame, 0x0101, jpat );
    DeleteObject( hSrcRgn );
	return jEG_OK;
}
//---------------------------------------------------------------------------
// API: ʂ̕` Draw Arc
//---------------------------------------------------------------------------
jERR __fastcall DisplayPrimitive::gdra_arc( jRECT r, jPNT sp, jPNT ep, jLATTR attr, jPATTERN *pat, jDEG angle, jDCM mode )
{
	jW result;
	CHECK_GID;
	CHECK_RECT;
	CHECK_PAT;
	CHECK_MODE;
	CHECK_ANGLE;
	Gwork gwk=Gwork( r, sp, ep, attr );
	HRGN hRgn=gwk.arcClip();
    if( hRgn == NULL )
    	return jEG_NOSPC;
    if( !SelectClipRgn( canvas->Handle, hRgn ) )
    	return jEG_NOSPC;
    jPAT *jpat;
    if( pat->spat.kind == 0 || pat->mpat.kind == 1 )
    {
    	int size;
    	result=gcre_pat( pat, NULL, &jpat, &size );
    }
    else
    if( pat->ipat.kind == 2 )
    	jpat=(jPAT *)pat->ipat.pat;
    else
    	result=jEG_PAR;
    if( result >= 0 )
    	tiling( r, attr, jpat );
	return jEG_OK;
}
//---------------------------------------------------------------------------
// API:`̕` Frame Sector
//---------------------------------------------------------------------------
jERR __fastcall DisplayPrimitive::gfra_sec( jRECT r, jPNT sp, jPNT ep, jLATTR attr, jPATTERN *pat, jDEG angle, jDCM mode )
{
	jW result;
	CHECK_GID;
	CHECK_RECT;
	CHECK_PAT;
	CHECK_MODE;
	CHECK_ANGLE;
	Gwork gwk=Gwork( r, sp, ep, attr );
	HRGN hRgn=gwk.fraSecClip();
    if( hRgn == NULL )
    	return jEG_NOSPC;
    if( !SelectClipRgn( canvas->Handle, hRgn ) )
    	return jEG_NOSPC;
    jPAT *jpat;
    if( pat->spat.kind == 0 || pat->mpat.kind == 1 )
    {
    	int size;
    	result=gcre_pat( pat, NULL, &jpat, &size );
    }
    else
    if( pat->ipat.kind == 2 )
    	jpat=(jPAT *)pat->ipat.pat;
    else
    	result=jEG_PAR;
    if( result >= 0 )
    	tiling( r, attr, jpat );
	return jEG_OK;
}
//---------------------------------------------------------------------------
// API: `̓hׂ Fill Sector
//---------------------------------------------------------------------------
jERR __fastcall DisplayPrimitive::gfil_sec( jRECT r, jPNT sp, jPNT ep, jPATTERN *pat, jDEG angle, jDCM mode )
{
	jW result;
	CHECK_GID;
	CHECK_RECT;
	CHECK_PAT;
	CHECK_MODE;
	CHECK_ANGLE;
	Gwork gwk=Gwork( r, sp, ep, 0x0101 );
	HRGN hRgn=gwk.filSecClip();
    if( hRgn == NULL )
    	return jEG_NOSPC;
    if( !SelectClipRgn( canvas->Handle, hRgn ) )
    	return jEG_NOSPC;
    //gid->Pie( src_r.left, src_r.top, src_r.right, src_r.bottom, (int)ep.x, (int)ep.y, (int)sp.x, (int)sp.y );
    jPAT *jpat;
    if( pat->spat.kind == 0 || pat->mpat.kind == 1 )
    {
    	int size;
    	result=gcre_pat( pat, NULL, &jpat, &size );
    }
    else
    if( pat->ipat.kind == 2 )
    	jpat=(jPAT *)pat->ipat.pat;
    else
    	result=jEG_PAR;
    if( result >= 0 )
    	tiling( r, 0x0101, jpat );
	return jEG_OK;
}
//---------------------------------------------------------------------------
// API: |`̘g̕` Frame Chord
//---------------------------------------------------------------------------
jERR __fastcall DisplayPrimitive::gfra_cho( jRECT r, jPNT sp, jPNT ep, jLATTR attr, jPATTERN *pat, jDEG angle, jDCM mode )
{
	jW result;
	CHECK_GID;
	CHECK_RECT;
	CHECK_PAT;
	CHECK_MODE;
	CHECK_ANGLE;
	Gwork gwk=Gwork( r, sp, ep, attr );
	HRGN hRgn=gwk.fraChoClip();
    if( hRgn == NULL )
    	return jEG_NOSPC;
    if( !SelectClipRgn( canvas->Handle, hRgn ) )
    	return jEG_NOSPC;
    jPAT *jpat;
    if( pat->spat.kind == 0 || pat->mpat.kind == 1 )
    {
    	int size;
    	result=gcre_pat( pat, NULL, &jpat, &size );
    }
    else
    if( pat->ipat.kind == 2 )
    	jpat=(jPAT *)pat->ipat.pat;
    else
    	result=jEG_PAR;
    if( result >= 0 )
    	tiling( r, attr, jpat );
	return jEG_OK;
}
//---------------------------------------------------------------------------
// API: |`̓hׂ` Fill Chord
//---------------------------------------------------------------------------
jERR __fastcall DisplayPrimitive::gfil_cho( jRECT r, jPNT sp, jPNT ep, jPATTERN *pat, jDEG angle, jDCM mode )
{
	jW result;
	CHECK_GID;
	CHECK_RECT;
	CHECK_PAT;
	CHECK_MODE;
	CHECK_ANGLE;
	Gwork gwk=Gwork( r, sp, ep, 0x0101 );
	HRGN hRgn=gwk.filChoClip();
    if( hRgn == NULL )
    	return jEG_NOSPC;
    if( !SelectClipRgn( canvas->Handle, hRgn ) )
    	return jEG_NOSPC;
    //gid->Pie( src_r.left, src_r.top, src_r.right, src_r.bottom, (int)ep.x, (int)ep.y, (int)sp.x, (int)sp.y );
    jPAT *jpat;
    if( pat->spat.kind == 0 || pat->mpat.kind == 1 )
    {
    	int size;
    	result=gcre_pat( pat, NULL, &jpat, &size );
    }
    else
    if( pat->ipat.kind == 2 )
    	jpat=(jPAT *)pat->ipat.pat;
    else
    	result=jEG_PAR;
    if( result >= 0 )
    	tiling( r, 0x0101, jpat );
	return jEG_OK;
}
//---------------------------------------------------------------------------
// API: ̕` Draw Polyline
//---------------------------------------------------------------------------
jERR __fastcall DisplayPrimitive::gdra_pln( jPOLYGON *p, jLATTR attr, jPATTERN *pat, jDCM mode )
{
	jW result;
	CHECK_GID;
	CHECK_ATTR;
	CHECK_PAT;
	CHECK_MODE;
	if( p->p_size <= 1 )
		return jEG_PAR;
	int p_max = p->p_size - 2;
	for( int i=0 ; i <= p_max ; i++ )
		_gdra_lin( p->p_pt[i], p->p_pt[i+1], attr, pat, mode );
	return jEG_OK;
}
//---------------------------------------------------------------------------
// API: p`̘g̕` Frame Polygon
//---------------------------------------------------------------------------
jERR __fastcall DisplayPrimitive::gfra_pol( jPOLY *p, jLATTR attr, jPATTERN *pat, jDCM mode )
{
	jW result;
	CHECK_GID;
	CHECK_ATTR;
	CHECK_PAT;
	CHECK_MODE;
	if( p->p_size <= 2 )
		return jEG_PAR;
	int p_max = p->p_size - 1;
	for( int i=0 ; i < p_max ; i++ )
		_gdra_lin( p->p_pt[i], p->p_pt[i+1], attr, pat, mode );
	//I_Ǝn_
	_gdra_lin( p->p_pt[ p->p_size - 1 ], p->p_pt[0], attr, pat, mode );
	return jEG_OK;
}
//---------------------------------------------------------------------------
// API: p`̓hׂ Fill Polygon
//---------------------------------------------------------------------------
jERR __fastcall DisplayPrimitive::gfil_pol( jPOLY *p, jPATTERN *pat, jDCM mode )
{
	jW result;
	CHECK_GID;
	CHECK_PAT;
	CHECK_MODE;
	if( p->p_size <= 2 )
		return jEG_PAR;
    POINT *pgn=new POINT[p->p_size];
	_Pgn( p, pgn );
    HRGN hSrcRgn=CreatePolygonRgn( pgn, (int)( p->p_size ), ALTERNATE );
    if( hSrcRgn == NULL )
    	return jEG_NOSPC;
    if( !SelectClipRgn( canvas->Handle, hSrcRgn ) )
    {
    	DeleteObject( hSrcRgn );
    	return jEG_NOSPC;
    }
    RECT src_r;
    get_polygon_covering( pgn, p->p_size - 1, &src_r );
    jPAT *jpat;
    if( pat->spat.kind == 0 || pat->mpat.kind == 1 )
    {
    	int size;
    	result=gcre_pat( pat, NULL, &jpat, &size );
    }
    else
    if( pat->ipat.kind == 2 )
    	jpat=(jPAT *)pat->ipat.pat;
    else
    	result=jEG_PAR;
    jRECT frame;
    _RECT( src_r, frame );
    if( result >= 0 )
    	tiling( frame, 0x0101, jpat );
    DeleteObject( hSrcRgn );
	return jEG_OK;
}
//////////////////////////////////////////////////////////////////////////////////////
// XvCȐ̕` Draw Spline
// NOSPT
//////////////////////////////////////////////////////////////////////////////////////
jERR __fastcall DisplayPrimitive::gdra_spl( jH np, jPNT *pt, jLATTR attr, jPATTERN *pat, jDCM mode )
{
	jW result;
	CHECK_GID;
	CHECK_PAT;
	CHECK_MODE;
    return jEG_NOSPT;
}
//////////////////////////////////////////////////////////////////////////////////////
