//---------------------------------------------------------------------------
//fBXvCv~eBu݊@`֐
//---------------------------------------------------------------------------
#include "gpi.h"
#include "htable.h"
#define MINCHO	(jUH)(0x60C6)
#define GOTHIC	(jUH)(0x00C0)
#define RGOTHIC	(jUH)(0x18C0)
jUW gt_sjis( jUW index ); //from gt.cpp
//---------------------------------------------------------------------------
//[Nϐ
//---------------------------------------------------------------------------
void __fastcall DisplayPrimitive::init_gchstr(void)
{
	last_fude=DUMMY_TCODE;
	fude.x=0;
	fude.y=0;
	fude_dir=jTORIGHT;
	fude_fgc=jBLACK;
	fude_bgc=jWHITE;
    fude_tfc=_colorval_tcolor( &fude_fgc );
    fude_tbc=_colorval_tcolor( &fude_bgc );
	memset( &fude_gap, sizeof(fude_gap), 0 );
    fude_spec.fontid=1;
    fude_spec.attr=0;
    fude_spec.size.x=fude_chsz;
    fude_spec.size.y=fude_chsz;
    fude_inf.height=fude_chsz;
    fude_inf.width=fude_chsz;
    //Ƃ肠
    fude_inf.base=0;
    fude_inf.leading=0;
    _lang=LANG_SYSSCR;
}
//---------------------------------------------------------------------------
// API `ʒu̐ݒ Set Character Position
//---------------------------------------------------------------------------
jERR __fastcall DisplayPrimitive::gset_chp( jH h, jH v, jH abs )
{
	CHECK_GID;
	//Ύw
	if( abs != 0 )
	{
		fude.x=h;
		fude.y=v;
		return jEG_OK;
	}
	//Ύw
	fude.x+=h;
	fude.y+=v;
	return jEG_OK;
}
//---------------------------------------------------------------------------
// API `ʒu̎o Get Character Position
//---------------------------------------------------------------------------
jERR __fastcall DisplayPrimitive::gget_chp( jH *h, jH *v )
{
	CHECK_GID;
	*h=fude.x;
	*v=fude.y;
	return jEG_OK;
}
//---------------------------------------------------------------------------
// API `J[̐ݒ Set Character Color
//---------------------------------------------------------------------------
jERR __fastcall DisplayPrimitive::gset_chc( jCOLORVAL chfgc, jCOLORVAL chbgc )
{
	CHECK_GID;
	fude_fgc=chfgc;
	fude_bgc=chbgc;
	canvas->Font->Color=fude_tfc=_colorval_tcolor( &chfgc );
    fude_tbc=_colorval_tcolor( &chbgc );
	return jEG_OK;
}
//---------------------------------------------------------------------------
// API `J[̎o Get Character Color
//---------------------------------------------------------------------------
jERR __fastcall DisplayPrimitive::gget_chc( jCOLORVAL *chfgc, jCOLORVAL *chbgc )
{
	CHECK_GID;
	*chfgc=fude_fgc;
	*chbgc=fude_bgc;
	return jEG_OK;
}
//---------------------------------------------------------------------------
// API `^Ԋu̐ݒ Set Character Direction
//---------------------------------------------------------------------------
jERR __fastcall DisplayPrimitive::gset_chd( jH dir, jCHGAP *gap )
{
	CHECK_GID;
	if( dir > jTOARB )
		return jEG_PAR;
	if( dir >= 0 )
		fude_dir=dir;
	if( gap != NULL )
		fude_gap=*gap;
	return jEG_OK;
}
//---------------------------------------------------------------------------
// API `^Ԋu̎o Get Character Direction
//---------------------------------------------------------------------------
jERR __fastcall DisplayPrimitive::gget_chd( jCHGAP *gap )
{
	CHECK_GID;
	if( gap != NULL )
		*gap=fude_gap;
	return fude_dir;
}
//---------------------------------------------------------------------------
// lib TCY𓾂
// O̍WnPʂ̏ꍇAOԂB
//---------------------------------------------------------------------------
jUH get_chsz( jCHSIZE cz )
{
	_CHSIZE *chsz=(_CHSIZE *)&cz;
	jUH Chunit=(jUH)chsz->bitfield.U;
	jUH Chsize=(jUH)chsz->bitfield.S;
    jUH size=16;
    if( Chunit == 0 )
    	return 0;
    else
    if( Chunit == 1 )
	{
    	//P^QOiP^WOjP
		switch ( Chsize )
		{
			case 135:	size=8; break;	//1/2{
			case 203:	size=12; break;	//3/4{
			case 271:	size=16; break;	//1{
			case 406:	size=24; break;	//3/2{
			case 542:	size=32; break;	//2{
			case 813:	size=48; break;	//3{
			case 1084:	size=64; break;	//4{
			default:	size=(jUH)( Chsize * 16 / 271 );
		}
	}
    else
	if( Chunit == 2 )
	{
    	//P^QO|CgiP^PSSOC`jP
		switch ( Chsize )
		{
			case 96:	size=8; break;	//4.8p 1/2{
			case 144:	size=12; break;	//7.2p 3/4{
            case 168:   size=14; break; //8.4p
			case 192:	size=16; break;	//9.6p 1{
            case 216:   size=18; break; //10.8p
            case 240:   size=20; break; //12p
            case 264:   size=22; break; //13.2p
			case 288:	size=24; break;	//14.4p 3/2{
            case 312:   size=26; break; //15.6p
            case 336:   size=28; break; //16.8p
			case 384:	size=32; break;	//19.2p 2{
            case 480:   size=40; break; //24p
			case 576:	size=48; break;	//28.8p 3{
			case 768:	size=64; break;	//38.4p 4{
            case 1152:  size=96; break; //57.6p 6{
            case 1536:  size=128; break; //76.8p 8{
			default:	size=(jUH)( Chsize * 16 / 192 );
		}
	}
	return size;
}
//---------------------------------------------------------------------------
// API tHg̎w Set Font
//---------------------------------------------------------------------------
jERR __fastcall DisplayPrimitive::gset_fnt( jFONTSPEC *fnt )
{
	CHECK_GID;
	if( fnt == NULL )
    	return jEG_ADR;
    if(( fnt->size.x <= 0 ) || ( fnt->size.y <=0 ))
    	return jEG_PAR;
	fude_spec=*fnt;
    fude_inf.width=fude_spec.size.x;
    fude_inf.height=fude_spec.size.y;
    fude_inf.base=0;
    fude_inf.leading=0;
    //Ƃ肠
    //canvas->Font->Height=fude_spec.size.x;
    int size_max=max( fude_spec.size.x, fude_spec.size.y );
     _src_char->Width=size_max;
    _src_char->Height=size_max;
    _dst_char->Width=size_max;
    _dst_char->Height=size_max;
    if( fude_font != NULL )
    {
    	_src_char->Canvas->Font=fude_font;
        _dst_char->Canvas->Font=fude_font;
    }
    else
    {
    	_src_char->Canvas->Font->Name="lr ";
    	_dst_char->Canvas->Font->Name="lr ";
    }
    return jEG_OK;
}
//---------------------------------------------------------------------------
// API tHg̎o Get Font
//---------------------------------------------------------------------------
jERR __fastcall DisplayPrimitive::gget_fnt( jFONTSPEC *fnt, jFONTINF *inf )
{
	CHECK_GID;
    if( fnt == NULL )
    	return jEG_ADR;
    if( fnt == NULL )
    	return jEG_ADR;
    *fnt=fude_spec;
    *inf=fude_inf;
    return jEG_OK;
}
//---------------------------------------------------------------------------
// API ̎o Get Character Width
//---------------------------------------------------------------------------
jERR __fastcall DisplayPrimitive::gget_chw( jTC ch )
{
	CHECK_GID;
    return (jERR)fude_inf.width;
}
//---------------------------------------------------------------------------
// API ̎o Get Character Height
//---------------------------------------------------------------------------
jERR __fastcall DisplayPrimitive::gget_chh( jTC ch )
{
	CHECK_GID;
    return (jERR)fude_inf.height;
}
//---------------------------------------------------------------------------
// lib ԊuԂ
// 0<=|gap|<=4096
//---------------------------------------------------------------------------
jH __fastcall DisplayPrimitive::get_gappixel( jH ch, jH gap )
{
	//΃sNZw
	if( gap < 256 )
		return gap;
	//TCYw
	return (jH)( (jH)gget_chh( ch ) * ( gap - (jH)256 ) / (jH)256 );
}
//---------------------------------------------------------------------------
// lib ̕ʒuɐi߂
//---------------------------------------------------------------------------
void __fastcall DisplayPrimitive::set_nextchp( jTC ch )
{
	jCHGAP px;
	jH h=0;
	jH v=0;
	jH dir = (jH)gget_chd( &px );
	jH chh = (jH)gget_chh( ch );
	jH chw = (jH)gget_chw( ch );
	//ϕ󔒂̒łȂȂ[
	if( ch != 0x20 )
	{
		px.hspgap = 0;
		px.vspgap = 0;
	}
	px.hgap=get_gappixel( ch, px.hgap );
	px.vgap=get_gappixel( ch, px.vgap );
	px.hspgap=get_gappixel( ch, px.hspgap );
	px.vspgap=get_gappixel( ch, px.vspgap );
	switch( dir )
	{
		case jTORIGHT:	h=(jH)( chw+px.hgap + px.hspgap ); break;
		case jTOLEFT:	h=(jH)( chw+px.hgap + px.hspgap ); h=(jH)(-h); break;
		case jTODOWN:	v=(jH)( chh+px.vgap + px.vspgap ); break;
		case jTOUP:		v=(jH)( chh+px.vgap + px.vspgap ); v=(jH)(-v); break;
		case jTOARB:	h=px.hgap; v=px.vgap;
	}
	//Έʒuw
	gset_chp( h, v, 0 );
}
//---------------------------------------------------------------------------
/*
IMPORT WORD gget_vis( WORD gid, RECT *r );
void cnv_corLEN( UWORD *l );		//from cor.c
//---------------------------------------------------------------------------
// ̕`͈͂ɂ邩H
// i\͈͂ɂȂ̂߂ɃtHgt@Cǂނ̂h߁j
//---------------------------------------------------------------------------
//p:`Wn_
//---------------------------------------------------------------------------
bool check_visible_char( WORD gid, TCODE ch, POINT *p )
{
	RECT v;	//\`
	RECT r;	//``
	UWORD chh;
	UWORD chw;
	gget_vis( gid, &v );
	//viewportݒ肵ꍇA`挴_(0,0)ɍ킹
	v.c.right -= v.c.left;
	v.c.bottom -= v.c.top;
	v.c.left = 0;
	v.c.top = 0;
	chw = gget_chw( gid, ch );
	chh = gget_chh( gid, ch );
	cnv_corLEN( &chw );
	cnv_corLEN( &chh );
	r.p.lefttop = *p;
	r.c.right = r.c.left + chw;
	r.c.bottom = r.c.top + chh;

	if( r.c.right < v.c.left )
		return FALSE;
	if( r.c.left >= v.c.right )
		return FALSE;
	if( r.c.bottom < v.c.top )
		return FALSE;
	if( r.c.top >= v.c.bottom )
		return FALSE;
	else
		return TRUE;
}
*/
//---------------------------------------------------------------------------
int tstrlen( jTC* ts )
{
	int len;
	for( int i=0 ; ; i++ )
    {
    	if( ts[i] == jTNULL )
        {
        	len=i+2;
            break;
        }
    } //for i
    if( len < 2 )
    	return 0;
    else
    	return ( len - 2 );
}

//---------------------------------------------------------------------------
// SpTRON(JIS)R[h𔼊pR[h(ASCII)ɕϊ
//---------------------------------------------------------------------------
bool __fastcall zentohan( jTC *tc, char *sj )
{
	#define UA	0x2341
	#define UZ	0x235A
	#define LA	0x2361
	#define LZ	0x237A
	#define N0	0x2330
	#define N9	0x2339
    #define CNV_NUM 33
    char ascii_table[ CNV_NUM ]={ '!',0x22,0x22,'#','$','%','&',0x27,0x27,'(',')','*','+',',','-','.','/',':',';','<','=','>','?','@','[','\\',']','^','_','{','|','}','~'};
	jTC jis_table[ CNV_NUM ]={0x212A,0x2148,0x2149,0x2174,0x2170,0x2173,0x2175,0x2146,0x2147,0x214A,0x214B,0x2176,0x215C,0x2124,0x215D,0x2125,0x213F,0x2127,0x2128,0x2163,0x2161,0x2164,0x2129,0x2177,0x214E,0x2143,0x214F,0x2130,0x2132,0x2150,0x2143,0x2151,0x2141};
    sj[1]=NULL;
	if( *tc >= (jUH)N0	&& *tc <= (jUH)N9 )
    {
    	sj[0]=(char)( *tc - (jUH)N0 + '0' );
        return true;
    }
	if( *tc >= (jUH)UA	&& *tc <= (jUH)UZ )
    {
    	sj[0]=(char)( *tc - (jUH)UA + 'A' );
        return true;
    }
	if( *tc >= (jUH)LA	&& *tc <= (jUH)LZ )
    {
    	sj[0]=(char)( *tc - (jUH)LA + 'a' );
        return true;
    }
    else
    {
    	for( int i=0 ; i < CNV_NUM ; i++ )
        {
        	if( jis_table[ i ] == *tc )
            {
            	sj[0]=ascii_table[ i ];
                return true;
            }
        } //for
    }
    return false;
}
//---------------------------------------------------------------------------
// XʂtcR[hɂāAG^seqԍie[uԍjԂB
//---------------------------------------------------------------------------
int __fastcall hotsuma_seq(jTC tc)
{
    int seq;
	jUH hi,lo;
    hi=(jUH)(( tc >> 8 ) & 0x00FF );
    lo=(jUH)( tc & 0x00FF );
    if( hi == 0x0094 )
        seq=lo-0x0020;
    else
    if( hi == 0x0095 )
        seq=96+lo-0x0020;
    else
        return 0;
    return seq;
}
//---------------------------------------------------------------------------
// brai01.ttf(p^bralle_1.lzh)tHgR[he[u(NABCC)
//---------------------------------------------------------------------------
static char Braille_table[64]={' ','A','1','B',0x60,'K','2','L',0x40,'C','I','F','/','M','S','P',0x22,'E','3','H','9','O','6','R','^','D','J','G','>','N','T','Q',0x2C,'*','5','<','-','U','8','V',0x2E,'%','[',0x24,'+','X','!','&',';',':','4',0x5C,'0','Z','7','(','_','?','W',']',0x23,'Y',')','='};
//---------------------------------------------------------------------------
// eudc.tte,eudc2.tte,eudc3.tte(PARAGON tenfont3.lzh)tHgR[he[u
//---------------------------------------------------------------------------
//static char EUDC_table[64]={0x21,0x61,0x51,0x62,0x47,0x6B,0x52,0x6C,0x60,0x63,0x69,0x66,0x4F,0x6D,0x73,0x70,0x42,0x65,0x53,0x68,0x59,0x6F,0x56,0x72,0x7E,0x64,0x6A,0x67,0x5E,0x6E,0x74,071,0x4C,0x4A,0x55,0x5C,0x4D,0x75,0x58,0x76,0x4E,0x45,0x7B,0x44,0x4B,0x78,0x41,0x46,0x5B,0x5A,0x54,0x7C,0x50,0x7A,0x57,0x48,0x80,0x5F,0x77,0x7D,0x43,0x79,0x49,0x5D};
//---------------------------------------------------------------------------
// TRON(JIS)R[hVtgJISR[hɕϊ
//---------------------------------------------------------------------------
void __fastcall shift_char( jTC *tc, char *sj )
{
	jUH hi,lo;
    hi=(jUH)(( *tc >> 8 ) & 0x00FF );
    lo=(jUH)( *tc & 0x00FF );
    if(( hi == 0x0080 ) && ( lo >= 0x0021 && lo <= 0x0060 ))
    {
        int seq=lo-0x0021;
        //if( seq >= 64 ) return;
        //sj[0]=Braille_table[seq];
        //if( seq == 0 )
        //    sj[0]=NULL;
        //else
        //{
            //sj[0]=(char)EUDC_table[seq];
            //sj[1]=(char)0x70;
            sj[0]=(char)Braille_table[seq];
            sj[1]=NULL;
            //sj[2]=NULL;
        //}
        return;
    }
    else
    if(!( hi >= (jUH)0x0021 && hi <= (jUH)0x007E ) && ( lo >= (jUH)0x0021 && lo <= (jUH)0x007E ))
    {
    	sj[0]=(char)0x21;
        sj[1]=(char)0x21;
        sj[2]=NULL;
        return;
    }
    if( ( hi & (jUH)0x0001 ) == (jUH)1 )
    	lo=(jUH)( lo + 0x001F );
    else
    	lo=(jUH)( lo + 0x007D );
    if( lo >= (jUH)0x007F )
    	lo++;
    hi=(jUH)( (hi - (jUH)0x0021 ) / (jUH)2 + (jUH)0x0081 );
    if( hi > (jUH)0x009F )
    	hi =(jUH)( hi + 0x0040 );

/*
    if( hi & (jUH)0x0001 )
    {
    	if( hi < (jUH)0x0060 )
    		lo += (jUH)0x001F;
    	else
        	lo += (jUH)0x0020;
    }
    else
    {
     	if( hi < (jUH)0x005F )
        	hi=(jUH)(( hi + 0x00E1 ) >> 1);
        else
        	hi=(jUH)(( hi + 0x0161 ) >> 1);
    }
*/
    sj[0]=(char)hi;
    sj[1]=(char)lo;
}
//---------------------------------------------------------------------------
//  wR[hZbgBiƎgj
//---------------------------------------------------------------------------
jERR __fastcall DisplayPrimitive::gset_lng( jTC lang )
{
	jUB chba =(jUB)( lang & 0x00FF );			//ʃoCg
	jUB chbb =(jUB)( (lang >> 8) & 0x00FF );	//ʃoCg
	if ((chbb == 0xFE) && (0x21 <= chba) && (chba <= 0x7E))
    {
        _lang=lang;
		return jEG_OK;
    }
	if ((chbb == 0xFE) && (0x80 <= chba) && (chba <= 0xFE))
    {
        _lang=lang;
		return jEG_OK;
    }
    return jEG_PAR;
}
//---------------------------------------------------------------------------
//  wR[hԂB
//---------------------------------------------------------------------------
jERR __fastcall DisplayPrimitive::gget_lng(jTC *lang)
{
    (jTC)*lang=_lang;
    return jEG_OK;
}
//---------------------------------------------------------------------------
// TRON(JIS)VtgJISɕϊ
//---------------------------------------------------------------------------
void shift_str( jTC* ts, char* str )
{
	for( int i=0,j=0 ; i < tstrlen(ts) ; i++, j+=2 )
    	shift_char( &ts[i], &str[j] );
}
//---------------------------------------------------------------------------
//s`c TRONR|h]|f
//---------------------------------------------------------------------------
bool __fastcall DisplayPrimitive::judge_TRONzone( jTC* ch, int *zone )
{
	jUB chba =(jUB)( *ch & 0x00FF );			//ʃoCg
	jUB chbb =(jUB)( (*ch >> 8) & 0x00FF );	//ʃoCg
	if ((0x21 <= chba) && (chba <= 0x7E))
	{
		if (( 0x21 <= chbb) && ( chbb <= 0x7E))
		{
			*zone = A_ZONE; // A zone
			return true;
		}
		else if (( 0x80 <= chbb) && ( chbb <= 0xFD ))
		{
			*zone = B_ZONE; // B zone
			return true;
		}
	}
	if ((0x80 <= chba) && (chba <= 0xFD))
	{
		if (( 0x21 <= chbb) && ( chbb <= 0x7E))
		{
			*zone = C_ZONE; // C zone
			return true;
	        }
		else if (( 0x80 <= chbb) && ( chbb <= 0xFD ))
		{
			*zone = D_ZONE; // D zone
			return true;
		}
	}
    return false;
}
//---------------------------------------------------------------------------
// wR[hƕR[h^ĕԂB
//---------------------------------------------------------------------------
int _fastcall char_kind(jTC lang,jTC tc)
{
	jUB lo =(jUB)( tc & 0x00FF );			//ʃoCg
	jUB hi =(jUB)( (tc >> 8) & 0x00FF );     //ʃoCg

    switch(lang)
    {
        case LANG_9:
                   switch( hi )
                   {
                        case 0x0091:
                             if( lo >= 0x0020 && lo <= 0x007F )
                                 return CHAR_IMODE;
                             else
                                 return CHAR_NULL;
                             //break;
                        case 0x0092:
                             if( lo >= 0x0020 && lo <= 0x007F )
                                 return CHAR_IMODE;
                             else
                                 return CHAR_NULL;
                             //break;
                        case 0x0093:
                             if( lo >= 0x0020 && lo <= 0x0032 )
                                 return CHAR_IMODE;
                             else
                                 return CHAR_NULL;
                             //break;
                        case 0x0094:
                             if( lo >= 0x0020 && lo <= 0x007F )
                                 return CHAR_HOTSUMA;
                             else
                                 return CHAR_NULL;
                             //break;
                        case 0x0095:
                             if( lo >= 0x0020 && lo <= 0x005F )
                                 return CHAR_HOTSUMA;
                             else
                                 return CHAR_NULL;
                             //break;
                        default:
                             return CHAR_NULL;
                   }
                   //break;
        default:
                return CHAR_NULL;
    }
}
//---------------------------------------------------------------------------
// `挴n֐
//---------------------------------------------------------------------------
void __fastcall DisplayPrimitive::drawTC( jTC tc,const int &x, const int &y, const int &width, const int &height, const TColor &fcol, const TColor &bcol, const jUH &fattr )
{
    switch(_lang)
    {
        case LANG_SYSSCR:   drawTCsys(tc,x,y,width,height,fcol,bcol,fattr); break;
        case LANG_GT1:      drawTCgt(tc,x,y,width,height,fcol,bcol,fattr); break;
        case LANG_GT2:      drawTCgt(tc,x,y,width,height,fcol,bcol,fattr); break;
        //Vł蕶̃T|[gł؂B
        //case LANG_MK1:      drawTCmk1(tc,x,y,width,height,fcol,bcol,fattr); break;
        //case LANG_MK2:      drawTCmk2(tc,x,y,width,height,fcol,bcol,fattr); break;
        //case LANG_MK3:      drawTCmk3(tc,x,y,width,height,fcol,bcol,fattr); break;
        case LANG_9:
                    switch( char_kind(_lang,tc) )
                    {
                        case CHAR_HOTSUMA:
                             drawTChot(tc,x,y,width,height,fcol,bcol,fattr); break;
                        case CHAR_IMODE:
                             drawTCimode(tc,x,y,width,height,fcol,bcol,fattr); break;
                    }
                    break;
        default: break;
    }
}
//---------------------------------------------------------------------------
// VXeXNvgtcJISRł邩H
//---------------------------------------------------------------------------
bool check_jis3(jTC tc)
{
    jUB hb =(jUB)( (tc >> 8) & 0x00FF );	    //ʃoCg
    if( hb < 0x0022 || hb > 0x007E ) return false;
    if( tc >= 0x2230 && tc <= 0x2239 ) return true;
    if( tc >= 0x2242 && tc <= 0x2249 ) return true;
    if( tc >= 0x2251 && tc <= 0x225B ) return true;
    if( tc >= 0x226B && tc <= 0x2271 ) return true;
    if( tc >= 0x227A && tc <= 0x227D ) return true;
    if( tc >= 0x2321 && tc <= 0x232F ) return true;
    if( tc >= 0x233A && tc <= 0x233F ) return true;
    if( tc == 0x2340 ) return true;
    if( tc >= 0x235B && tc <= 0x2360 ) return true;
    if( tc >= 0x237B && tc <= 0x237E ) return true;
    if( tc >= 0x2474 && tc <= 0x247E ) return true;
    if( tc >= 0x2577 && tc <= 0x257E ) return true;
    if( tc >= 0x2639 && tc <= 0x2640 ) return true;
    if( tc >= 0x2659 && tc <= 0x267E ) return true;
    if( tc >= 0x2742 && tc <= 0x2750 ) return true;
    if( tc >= 0x2772 && tc <= 0x277E ) return true;
    if( tc >= 0x2841 && tc <= 0x287E ) return true;
    if( hb >= 0x29 && hb <= 0x2F ) return true;
    if( tc >= 0x4F54 && tc <= 0x4F7E ) return true;
    if( tc >= 0x7427 && tc <= 0x747E ) return true;
    if( hb >= 0x75 && hb <= 0x7E ) return true;
    return false;
}
//---------------------------------------------------------------------------
// VXeXNvgtcJISSł邩H^̏ꍇAVtgJISR[hԂB
// R[ht̓t[tHgKandatåtɏ]B
//---------------------------------------------------------------------------
bool check_jis4(jTC tc,char *sj)
{
	jUH hi,lo;
    hi=(jUH)(( tc >> 8 ) & 0x00FF );
    lo=(jUH)( tc & 0x00FF );
    sj[0]=(char)0x21;
    sj[1]=(char)0x21;
    sj[2]=NULL;
    if(!( hi >= (jUH)0x0087 && hi <= (jUH)0x00A0 ) && ( lo >= (jUH)0x0021 && lo <= (jUH)0x007F ))
        return false;
    //rŃR[hԃO[v
    jUH hi_new=0;
    switch( hi )
    {
        case 0x0087:
             hi_new=0x00F0;
             break;
        case 0x0088:
             hi_new=0x00F1;
             break;
        case 0x008A:
             hi_new=0x00F2;
             break;
        case 0x008D:
             hi_new=0x00F3;
             break;
        case 0x008F:
             hi_new=0x00F4;
             break;
        case 0x0091:
             hi_new=0x00F5;
             break;
        case 0x0093:
             hi_new=0x00F6;
             break;
        case 0x0095:
             hi_new=0x00F7;
             break;
        case 0x0097:
             hi_new=0x00F8;
             break;
        case 0x0099:
             hi_new=0x00F9;
             break;
        case 0x009B:
             hi_new=0x00FA;
             break;
        case 0x009D:
             hi_new=0x00FB;
             break;
        case 0x009F:
             hi_new=0x00FC;
             break;
    }
    switch( hi )
    {
        case 0x0087:
        case 0x0088:
        case 0x008A:
        case 0x008D:
        case 0x008F:
        case 0x0091:
        case 0x0093:
        case 0x0095:
        case 0x0097:
        case 0x0099:
        case 0x009B:
        case 0x009D:
        case 0x009F:
             if( lo >= 0x0020 && lo <= 0x005F )
             {
                sj[0]=(char)hi_new;
                sj[1]=(char)((lo-0x0021)+0x0040);
                sj[2]=NULL;
                return true;
             }
             else
             {
                sj[0]=(char)hi_new;
                sj[1]=(char)((lo-0x0060)+0x0080);
                sj[2]=NULL;
                return true;
             }
    }
    switch( hi )
    {
        //ʃoCg0x009F-0x00FC̃O[v
        case 0x0089:
             hi_new=0x00F1;
             break;
        case 0x008B:
             hi_new=0x00F0;
             break;
        case 0x008C:
             hi_new=0x00F2;
             break;
        case 0x008E:
             hi_new=0x00F3;
             break;
        case 0x0090:
             hi_new=0x00F4;
             break;
        case 0x0092:
             hi_new=0x00F5;
             break;
        case 0x0094:
             hi_new=0x00F6;
             break;
        case 0x0096:
             hi_new=0x00F7;
             break;
        case 0x0098:
             hi_new=0x00F8;
             break;
        case 0x009A:
             hi_new=0x00F9;
             break;
        case 0x009C:
             hi_new=0x00FA;
             break;
        case 0x009E:
             hi_new=0x00FB;
             break;
        case 0x00A0:
             hi_new=0x00FC;
             break;
        default:
             return false;
    }
    sj[0]=(char)hi_new;
    sj[1]=(char)((lo-0x0021)+0x009F);
    sj[2]=NULL;
    return true;
}
//---------------------------------------------------------------------------
// `挴n֐iVXeXNvgj
//---------------------------------------------------------------------------
void __fastcall DisplayPrimitive::drawTCsys( jTC tc,const int &x, const int &y, const int &width, const int &height, const TColor &fcol, const TColor &bcol, const jUH &fattr )
{
    int zone;
	if( !judge_TRONzone( &tc, &zone ) )
        return;
    bool change_font=false;
    TFontName src_old;
    TFontName dst_old;
    jUH hi,lo;
    hi=(jUH)(tc >> 8);
    lo=(jUH)(tc & 0x00FF);
    _src_char->Canvas->Font->Charset=SHIFTJIS_CHARSET;
    _dst_char->Canvas->Font->Charset=SHIFTJIS_CHARSET;
    if(( hi >= 0x0021 && hi <= 0x0061 ) && ( lo >= 0x0080 && lo <= 0x00FD ))
    {
        //ݖT|[g
        return;
        //GB2312
        //change_font=true;
        //src_old=_src_char->Canvas->Font->Name;
        //dst_old=_dst_char->Canvas->Font->Name;
//        _src_char->Canvas->Font->Name="DFHei-GB";
//        _dst_char->Canvas->Font->Name="DFHei-GB";
//        _src_char->Canvas->Font->Charset=GB2312_CHARSET;
//        _dst_char->Canvas->Font->Charset=GB2312_CHARSET;
    }
    else
    if(( hi >= 0x00B7 && hi <= 0x00FC ) && ( lo >= 0x0080 && lo <= 0x00FD ))
    {
        //ݖT|[g
        return;
        //KSC
    }
    else
    if( zone == B_ZONE )
    {
    	if( (jUH)tc >= (jUH)0xB021 )
        {
        	//R[⏕W3Ή
            //⏕tHg؂ւAR[hϊ
        	change_font=true;
            src_old=_src_char->Canvas->Font->Name;
            dst_old=_dst_char->Canvas->Font->Name;
            //_src_char->Canvas->Font->Name="HGW3⏕@X12";
            //_dst_char->Canvas->Font->Name="HGW3⏕@X12";
            _src_char->Canvas->Font->Name=hojo_font->Name;
            _dst_char->Canvas->Font->Name=hojo_font->Name;
            if( (jUH)tc >= (jUH)0xCF21 )
            	tc=(jUH)( tc - 0xB000 + 0x3100 );	//Windows NT̂47΂B
            else
            	tc=(jUH)( tc - 0xB000 + 0x3000 );
        }
        else
        if(( hi == 0x0080 ) && ( lo >= 0x0021 && lo <= 0x0060 ))
        {
            //U__
            change_font=true;
            src_old=_src_char->Canvas->Font->Name;
            dst_old=_dst_char->Canvas->Font->Name;
            //_src_char->Canvas->Font->Name="EUDC";
            //_dst_char->Canvas->Font->Name="EUDC";
            _src_char->Canvas->Font->Name="Braille";
            _dst_char->Canvas->Font->Name="Braille";
            _src_char->Canvas->Font->Charset=ANSI_CHARSET;
            _dst_char->Canvas->Font->Charset=ANSI_CHARSET;
        }
    }
    else
    //JISR
    if( check_jis3( tc ) )
    {
        //KandatatHg
        change_font=true;
        src_old=_src_char->Canvas->Font->Name;
        dst_old=_dst_char->Canvas->Font->Name;
        _src_char->Canvas->Font->Name="Kandata";
        _dst_char->Canvas->Font->Name="Kandata";
    }
    char sj[8];
    sj[2]=NULL;
    bool hankaku=false;
//    jUH seq=0;

//char msg[100];
    if(( hi >= 0x0021 && hi <= 0x0061 ) && ( lo >= 0x0080 && lo <= 0x00FD ))
    {
    //char msg[100];
    //sprintf(msg,"sj %s %x %x : , tc=%x", _dst_char->Canvas->Font->Name,sj[1],sj[0],tc );
    //ShowMessage(msg);
//    hi=0x2e;
//    lo=0xb7;
//        seq=(hi-0x0021)*126+(lo-0x0080);

//        jUH xx,yy;
        //xx=0x00a1-seq%94;
        //yy=0x00B3-seq/94;

        //sj[0]=(seq%94)+0x00A1;
        //sj[1]=(seq/94)+0x00A4;
        sj[0]=0x21;
        sj[1]=0x21;
        sj[2]=NULL;
    }
    else
//    if( width * 2 <= height )
    if( width != height )
    {
    	//ipx[Xj̏ꍇ̂ŁƂB
    	hankaku=zentohan( &tc, sj );
        if( !hankaku )
        	shift_char( &tc, sj );
    }
    else
    {
        //JISS
        if( check_jis4( tc, sj ) )
        {
            if( change_font == false )
            {
                //KandatatHg
                change_font=true;
                src_old=_src_char->Canvas->Font->Name;
                dst_old=_dst_char->Canvas->Font->Name;
                _src_char->Canvas->Font->Name="Kandata";
                _dst_char->Canvas->Font->Name="Kandata";
            }
        }
        else
    	    shift_char( &tc, sj );
    }
    //P`ifobOj
	//canvas->TextOut( x, y, AnsiString(sj) );
    //gray_font.TextOut(canvas,_dst_char,x,y,sj);
    //return;

    if( hankaku || width == height )
    {
    	//iSpj͌`iڕ`j
    	//obt@TCYݒ
        _dst_char->Height=height;
        _dst_char->Width=width;
        //fnp
    	_dst_char->Canvas->Brush->Style=bsSolid;
		_dst_char->Canvas->Brush->Color=TRANSPARENT_COLOR;
    	_dst_char->Canvas->FillRect( Rect( 0, 0, _dst_char->Width , _dst_char->Height ) );
        _dst_char->Canvas->Font->Height=height;
        _dst_char->Canvas->Font->Pitch=fpFixed;
    	//obt@ɕ`
        if( hankaku == true )
        {
            AnsiString as=AnsiString(sj);
            int tw=_dst_char->Canvas->TextWidth(as);
            int h=(height*width)/tw;
            int sx=0;
            int sy=0;
            if( width > tw )
                sx=(width - tw )/2;
            if( height > h )
                sy=(height-h)/2;
            _dst_char->Canvas->Font->Height=h;
    	    _dst_char->Canvas->Font->Color=fcol;
    	    _dst_char->Canvas->Brush->Style=bsClear;
            _dst_char->Canvas->TextOut( sx, sy, as);

/*
            _src_char->Height=max(height,width);
            _src_char->Width=max(height,width);
            AnsiString as=AnsiString(sj);
            _src_char->Canvas->Font->Height=max(height,width);
            int tw=_src_char->Canvas->TextWidth(as);
            int h=(height*width)/tw;
   		    _src_char->Canvas->Font->Height=h;
            _src_char->Height=h;
            _src_char->Width=tw;
            //fnp
    	    _src_char->Canvas->Brush->Style=bsSolid;
		    _src_char->Canvas->Brush->Color=TRANSPARENT_COLOR;
    	    _src_char->Canvas->FillRect( Rect( 0, 0, _src_char->Width , _src_char->Height ) );
    	    //obt@ɕ`
   		    _src_char->Canvas->Font->Height=height;
    	    _src_char->Canvas->Font->Pitch=fpFixed;
    	    _src_char->Canvas->Font->Color=fcol;
    	    _src_char->Canvas->Brush->Style=bsClear;
    	    _src_char->Canvas->TextOut( 0, 0,as);
            //gk
    	    TRect r=Rect( 0, 0, width, height );
    	    _dst_char->Canvas->CopyMode=cmSrcCopy;
    	    _dst_char->Canvas->StretchDraw( r, _src_char );
*/
        }
        else
        {
    	    _dst_char->Canvas->Font->Color=fcol;
    	    _dst_char->Canvas->Brush->Style=bsClear;
            _dst_char->Canvas->TextOut( 0, 0, AnsiString(sj));
        }
    }
    else
    {
    	//obt@TCYݒ
        _src_char->Height=height;	//
        _src_char->Width=height;
        _dst_char->Height=height;
        _dst_char->Width=width;
    	//fnp
    	_src_char->Canvas->Brush->Style=bsSolid;
		_src_char->Canvas->Brush->Color=TRANSPARENT_COLOR;
    	_src_char->Canvas->FillRect( Rect( 0, 0, _src_char->Width , _src_char->Height ) );
    	//obt@ɕ`
   		_src_char->Canvas->Font->Height=height;
    	_src_char->Canvas->Font->Pitch=fpFixed;
    	_src_char->Canvas->Font->Color=fcol;
    	_src_char->Canvas->Brush->Style=bsClear;
    	_src_char->Canvas->TextOut( 0, 0, AnsiString(sj));
        //gk
    	TRect r=Rect( 0, 0, width, height );
    	_dst_char->Canvas->CopyMode=cmSrcCopy;
    	_dst_char->Canvas->StretchDraw( r, _src_char );
    }
    //wi`
    canvas->CopyMode=cmSrcCopy;
    _characters->Clear();
    _characters->Width=_dst_char->Width;
    _characters->Height=_dst_char->Height;
    if( _characters->AddMasked( _dst_char, TRANSPARENT_COLOR ) == 0 )
    {
    	_char_index=0;
    	if( _characters->Count > 0 )
    		_char_index=_characters->Count - 1;
    	_characters->Draw( canvas, x, y, _char_index,true );
	}
    //tHg؂ւA
    if( change_font )
    {
		_src_char->Canvas->Font->Name=src_old;
    	_dst_char->Canvas->Font->Name=dst_old;
    }
    _src_char->Canvas->Font->Charset=SHIFTJIS_CHARSET;
    _dst_char->Canvas->Font->Charset=SHIFTJIS_CHARSET;
}
//---------------------------------------------------------------------------
// wR[hƃgR[h^GTR[h̕ԍ𓾂B
//---------------------------------------------------------------------------
int __fastcall DisplayPrimitive::gtSeqT(jTC lang,jTC tc)
{
	int zone;
	if( !judge_TRONzone( &tc, &zone ) )
    	return 0;
    judge_TRONzone( &tc, &zone );
    int area_sum=0;
    int local_sum=0;
    int width=0;
    int x=(int)(tc & 0x00FF);
    int y=(int)((tc>>8)&0x00FF);
    switch(lang)
    {
        case 0xFE22:
        case 0xFE23:
             area_sum=(int)lang -(int)0xFE22;
             switch(zone)
             {
                case A_ZONE:
                     x-=(int)0x21;
                     y-=(int)0x21;
                     width=94;
                     local_sum=0; break;
                case B_ZONE:
                     x-=(int)0x21;
                     y-=(int)0x80;
                     width=94;
                     local_sum=8836; break;
                case C_ZONE:
                     x-=(int)0x80;
                     y-=(int)0x21;
                     width=126;
                     local_sum=20680; break;
                case D_ZONE:
                     x-=(int)0x80;
                     y-=(int)0x80;
                     width=126;
                     local_sum=32524; break;
                default:
                     local_sum=0;
             }
    }
    return ( area_sum*48400+local_sum+y*width+x+1 );
}
//---------------------------------------------------------------------------
// `挴n֐iGTR[hj
//---------------------------------------------------------------------------
void __fastcall DisplayPrimitive::drawTCgt( jTC tc,const int &x, const int &y, const int &width, const int &height, const TColor &fcol, const TColor &bcol, const jUH &fattr )
{
    TFontName src_old;
    TFontName dst_old;
    int ku,ten,base;
    src_old=_src_char->Canvas->Font->Name;
    dst_old=_dst_char->Canvas->Font->Name;
    int seq=gtSeqT(_lang,tc);
    if( seq == 0 )
        return;
    AnsiString mfont;
    char sj[3];
    sj[2]=NULL;
    jUW fs;
    fs=gt_sjis( seq );
    jUH fno;
    fno=fs >> 16;
    sj[1]=fs & 0x000000FF;
    sj[0]=(fs>>8) & 0x000000FF;
    switch( fno )
    {
        case 1:
                mfont="GT2000-01"; break;
        case 2:
                mfont="GT2000-02"; break;
        case 3:
                mfont="GT2000-03"; break;
        case 4:
                mfont="GT2000-04"; break;
        case 5:
                mfont="GT2000-05"; break;
        case 6:
                mfont="GT2000-06"; break;
        case 7:
                mfont="GT2000-07"; break;
        case 8:
                mfont="GT2000-08"; break;
        case 9:
                mfont="GT2000-09"; break;
        case 10:
                mfont="GT2000-10"; break;
        case 11:
                mfont="GT2000-11"; break;
        default:
                return;
    }
    _src_char->Canvas->Font->Name=mfont;
    _dst_char->Canvas->Font->Name=mfont;
    if( width == height )
    {
    	//iSpj͌`iڕ`j
    	//obt@TCYݒ
        _dst_char->Height=height;
        _dst_char->Width=width;
        //fnp
    	_dst_char->Canvas->Brush->Style=bsSolid;
		_dst_char->Canvas->Brush->Color=TRANSPARENT_COLOR;
    	_dst_char->Canvas->FillRect( Rect( 0, 0, _dst_char->Width , _dst_char->Height ) );
    	//obt@ɕ`
   		_dst_char->Canvas->Font->Height=height;
    	_dst_char->Canvas->Font->Pitch=fpFixed;
    	_dst_char->Canvas->Font->Color=fcol;
    	_dst_char->Canvas->Brush->Style=bsClear;
        _dst_char->Canvas->TextOut( 0, 0, AnsiString(sj));
    }
    else
    {
    	//obt@TCYݒ
        _src_char->Height=height;	//
        _src_char->Width=height;
        _dst_char->Height=height;
        _dst_char->Width=width;
    	//fnp
    	_src_char->Canvas->Brush->Style=bsSolid;
		_src_char->Canvas->Brush->Color=TRANSPARENT_COLOR;
    	_src_char->Canvas->FillRect( Rect( 0, 0, _src_char->Width , _src_char->Height ) );
    	//obt@ɕ`
   		_src_char->Canvas->Font->Height=height;
    	_src_char->Canvas->Font->Pitch=fpFixed;
    	_src_char->Canvas->Font->Color=fcol;
    	_src_char->Canvas->Brush->Style=bsClear;
    	_src_char->Canvas->TextOut( 0, 0, AnsiString(sj));
        //gk
    	TRect r=Rect( 0, 0, width, height );
    	_dst_char->Canvas->CopyMode=cmSrcCopy;
    	_dst_char->Canvas->StretchDraw( r, _src_char );
    }
    //wi`
    canvas->CopyMode=cmSrcCopy;
    _characters->Clear();
    _characters->Width=_dst_char->Width;
    _characters->Height=_dst_char->Height;
    if( _characters->AddMasked( _dst_char, TRANSPARENT_COLOR ) == 0 )
    {
    	_char_index=0;
    	if( _characters->Count > 0 )
    		_char_index=_characters->Count - 1;
    	_characters->Draw( canvas, x, y, _char_index,true );
	}
    _src_char->Canvas->Font->Name=src_old;
    _dst_char->Canvas->Font->Name=dst_old;
}
//---------------------------------------------------------------------------
// `挴n֐ii[hGR[hjRT|[g
//---------------------------------------------------------------------------
void __fastcall DisplayPrimitive::drawTCimode( jTC tc,const int &x, const int &y, const int &width, const int &height, const TColor &fcol, const TColor &bcol, const jUH &fattr )
{
    TFontName src_old;
    TFontName dst_old;
    int ku,ten,base;
    src_old=_src_char->Canvas->Font->Name;
    dst_old=_dst_char->Canvas->Font->Name;
    char sj[3];
    sj[2]=NULL;
    sj[0]=0x81;
    sj[1]=0x40;
    int itc=(int)tc;
    if( itc >= 0x00009120 && itc <= 0x0000917E )
    {
        sj[0]=0xF8;
        sj[1]=(char)(0x9F+(itc-0x00009121));
    }
    else
    if( itc >= 0x00009221 && itc <= 0x0000922A )
    {
        sj[0]=0xF9;
        sj[1]=(char)(0x40+(itc-0x00009221));
    }
    else
    if( itc >= 0x00009253 && itc <= 0x0000925F )
    {
        sj[0]=0xF9;
        sj[1]=(char)(0x72+(itc-0x00009253));
    }
    else
    if( itc >= 0x00009260 && itc <= 0x00009270 )
    {
        sj[0]=0xF9;
        sj[1]=(char)(0x80+(itc-0x00009260));
    }
    else
    if( itc >= 0x00009271 && itc <= 0x0000927E )
    {
        sj[0]=0xF9;
        sj[1]=(char)(0x91+(itc-0x00009271));
    }
    else
    if( itc >= 0x00009321 && itc <= 0x00009331 )
    {
        sj[0]=0xF9;
        sj[1]=(char)(0x9F+(itc-0x00009321));
    }
    else
    if( itc == 0x00009332 )
    {
        sj[0]=0xF9;
        sj[1]=0xB0;
    }
    else
        return;
    _src_char->Canvas->Font->Name="EUDC";
    _dst_char->Canvas->Font->Name="EUDC";
    if( width == height )
    {
    	//iSpj͌`iڕ`j
    	//obt@TCYݒ
        _dst_char->Height=height;
        _dst_char->Width=width;
        //fnp
    	_dst_char->Canvas->Brush->Style=bsSolid;
		_dst_char->Canvas->Brush->Color=TRANSPARENT_COLOR;
    	_dst_char->Canvas->FillRect( Rect( 0, 0, _dst_char->Width , _dst_char->Height ) );
    	//obt@ɕ`
   		_dst_char->Canvas->Font->Height=height;
    	_dst_char->Canvas->Font->Pitch=fpFixed;
    	_dst_char->Canvas->Font->Color=fcol;
    	_dst_char->Canvas->Brush->Style=bsClear;
        _dst_char->Canvas->TextOut( 0, 0, AnsiString(sj));
    }
    else
    {
    	//obt@TCYݒ
        _src_char->Height=height;	//
        _src_char->Width=height;
        _dst_char->Height=height;
        _dst_char->Width=width;
    	//fnp
    	_src_char->Canvas->Brush->Style=bsSolid;
		_src_char->Canvas->Brush->Color=TRANSPARENT_COLOR;
    	_src_char->Canvas->FillRect( Rect( 0, 0, _src_char->Width , _src_char->Height ) );
    	//obt@ɕ`
   		_src_char->Canvas->Font->Height=height;
    	_src_char->Canvas->Font->Pitch=fpFixed;
    	_src_char->Canvas->Font->Color=fcol;
    	_src_char->Canvas->Brush->Style=bsClear;
    	_src_char->Canvas->TextOut( 0, 0, AnsiString(sj));
        //gk
    	TRect r=Rect( 0, 0, width, height );
    	_dst_char->Canvas->CopyMode=cmSrcCopy;
    	_dst_char->Canvas->StretchDraw( r, _src_char );
    }
    //wi`
    canvas->CopyMode=cmSrcCopy;
    _characters->Clear();
    _characters->Width=_dst_char->Width;
    _characters->Height=_dst_char->Height;
    if( _characters->AddMasked( _dst_char, TRANSPARENT_COLOR ) == 0 )
    {
    	_char_index=0;
    	if( _characters->Count > 0 )
    		_char_index=_characters->Count - 1;
    	_characters->Draw( canvas, x, y, _char_index,true );
	}
    _src_char->Canvas->Font->Name=src_old;
    _dst_char->Canvas->Font->Name=dst_old;
}
//---------------------------------------------------------------------------
// `挴n֐iG^j
//---------------------------------------------------------------------------
void __fastcall DisplayPrimitive::drawTChot( jTC tc,const int &x, const int &y, const int &width, const int &height, const TColor &fcol, const TColor &bcol, const jUH &fattr )
{
    TFontName src_old;
    TFontName dst_old;
    int ku,ten,base;
    src_old=_src_char->Canvas->Font->Name;
    dst_old=_dst_char->Canvas->Font->Name;
    int seq=hotsuma_seq(tc);
    if( seq == 0 )
        return;
    char sj[3];
    sj[2]=NULL;
    sj[0]=hotsuma_table[seq];
    _src_char->Canvas->Font->Name="TCM Hotsuma Character";
    _dst_char->Canvas->Font->Name="TCM Hotsuma Character";
    if( width == height )
    {
    	//iSpj͌`iڕ`j
    	//obt@TCYݒ
        _dst_char->Height=height;
        _dst_char->Width=width;
        //fnp
    	_dst_char->Canvas->Brush->Style=bsSolid;
		_dst_char->Canvas->Brush->Color=TRANSPARENT_COLOR;
    	_dst_char->Canvas->FillRect( Rect( 0, 0, _dst_char->Width , _dst_char->Height ) );
    	//obt@ɕ`
   		_dst_char->Canvas->Font->Height=height;
    	_dst_char->Canvas->Font->Pitch=fpFixed;
    	_dst_char->Canvas->Font->Color=fcol;
    	_dst_char->Canvas->Brush->Style=bsClear;
        _dst_char->Canvas->TextOut( 0, 0, AnsiString(sj));
    }
    else
    {
    	//obt@TCYݒ
        _src_char->Height=height;	//
        _src_char->Width=height;
        _dst_char->Height=height;
        _dst_char->Width=width;
    	//fnp
    	_src_char->Canvas->Brush->Style=bsSolid;
		_src_char->Canvas->Brush->Color=TRANSPARENT_COLOR;
    	_src_char->Canvas->FillRect( Rect( 0, 0, _src_char->Width , _src_char->Height ) );
    	//obt@ɕ`
   		_src_char->Canvas->Font->Height=height;
    	_src_char->Canvas->Font->Pitch=fpFixed;
    	_src_char->Canvas->Font->Color=fcol;
    	_src_char->Canvas->Brush->Style=bsClear;
    	_src_char->Canvas->TextOut( 0, 0, AnsiString(sj));
        //gk
    	TRect r=Rect( 0, 0, width, height );
    	_dst_char->Canvas->CopyMode=cmSrcCopy;
    	_dst_char->Canvas->StretchDraw( r, _src_char );
    }
    //wi`
    canvas->CopyMode=cmSrcCopy;
    _characters->Clear();
    _characters->Width=_dst_char->Width;
    _characters->Height=_dst_char->Height;
    if( _characters->AddMasked( _dst_char, TRANSPARENT_COLOR ) == 0 )
    {
    	_char_index=0;
    	if( _characters->Count > 0 )
    		_char_index=_characters->Count - 1;
    	_characters->Draw( canvas, x, y, _char_index,true );
	}
    _src_char->Canvas->Font->Name=src_old;
    _dst_char->Canvas->Font->Name=dst_old;
}
//---------------------------------------------------------------------------
//from betafont.c
//void cnv_corPOINT( POINT *p );		//from cor.c
//void cnv_corCharPOINT( POINT *p );	//from cor.c
//void cnv_corLEN( UWORD *l );		    //from cor.c
//---------------------------------------------------------------------------
// API ̕` Draw Character
//---------------------------------------------------------------------------
jERR __fastcall DisplayPrimitive::gdra_chr( jTC ch, jDCM mode )
{
	jERR result;
	CHECK_GID;
	CHECK_MODE;
    if( result < 0 ) return result;
	//Wϊiۂɕ`悷Ƃ̕`ʒuWϊj
	//ʒuϐ͕ϊȂB
	//cnv_corCharPOINT( &p );
	//TCYϊ
	//cnv_corLEN( &chsz );
	//`͈͔
	//if( check_visible_char( gid, ch, &p ) == TRUE )
    //wR[hȂΌݒ肵AB
    if( gset_lng(ch) == jEG_OK )
        return jEG_OK;
    int x=(int)fude.x;
    int y=(int)fude.y;
    int w=(int)fude_inf.width;
    int h=(int)fude_inf.height;
    drawTC( ch, x, y, w, h, fude_tfc, fude_tbc, fude_spec.attr );
	//ʒui߂
	set_nextchp( ch );
	return jEG_OK;
}
//---------------------------------------------------------------------------
//̕`iʒuwj Draw Character at Position
//---------------------------------------------------------------------------
jERR __fastcall DisplayPrimitive::gdra_chp( jH h, jH v, jTC ch, jDCM mode )
{
	jERR result;
	CHECK_GID;
	CHECK_MODE;
	result=gset_chp( h, v, 1 );
	if( result < 0 )
		return result;
	return gdra_chr( ch, mode );
}
//---------------------------------------------------------------------------
// API ̕` Draw String
//---------------------------------------------------------------------------
jERR __fastcall DisplayPrimitive::gdra_str( jTC *str, jH len, jDCM mode )
{
	jERR result;
	CHECK_GID;
	CHECK_MODE;
	if( len < 0 )
		return jEG_PAR;
	jH l = (jH)strlen((char *)str);
	l = min( len, (jH)(l/2) );
	result=gset_chc( fude_fgc, fude_bgc );
    if( result < 0 )
    	return result;
	for( int i=0 ; i < l ; i++ )
		gdra_chr( (jTC)( str + i * 2 ), mode );
	return jEG_OK;
}
//---------------------------------------------------------------------------
// API ̕`iʒuwj Draw String at Position
//---------------------------------------------------------------------------
jERR __fastcall DisplayPrimitive::gdra_stp( jH h, jH v, jTC* str, jH len, jDCM mode )
{
	jERR result=gset_chp( h, v, 1 );
	if( result < 0 )
		return result;
	return gdra_str( str, len, mode );
}

