//---------------------------------------------------------------------------
//
//	  y TAD viewer for Windows z
//    Display Primitive library
//	  JJ,micropower,HigashiHiroshima City,1997-2001
//
//---------------------------------------------------------------------------
#ifndef __DPCLASSH__
#define __DPCLASSH__
#include "btype32.h"
#include "tadseg.h"
#include "btad.h"
#include "dp.h"
#include "bcolor.h"
#include "taddata.h"
#include "clip.h"
#include "er_eg.h"
#include "tadimg.h"
#include "grayfont.h"
//---------------------------------------------------------------------------
// prototype
//---------------------------------------------------------------------------
bool _colorval_rgbquad( jCOLORVAL *cv, RGBQUAD *q, bool *transparent );
void _rgbquad_colorval( RGBQUAD *q, bool transparent, jCOLORVAL *cv );
jH	_scaler( jH w, jSCALE s );
jUH	get_chsz( jCHSIZE cz );
//---------------------------------------------------------------------------
typedef struct {
	int index;
	Graphics::TBitmap	*bmp;
} jPAT;
//---------------------------------------------------------------------------
// gopn_devprameter
//---------------------------------------------------------------------------
typedef struct {
	TCanvas*	gid;
	TImageList*	patImageList;
	TImageList*	charImageList;
    TImage*		screenImage;
    TFont*		screenFont;
    TFont*		hojokanji;
} jPARAM;
//---------------------------------------------------------------------------
// ``FbN
//---------------------------------------------------------------------------
#define CHECK_GID	if( !Check() ) return jEG_GID;
//---------------------------------------------------------------------------
const TColor TRANSPARENT_COLOR=clMaroon;	    //F
//---------------------------------------------------------------------------
//fBXvCv~eBuIuWFNg
//---------------------------------------------------------------------------
class DisplayPrimitive
{
	private:
    	//CONSTANT
        #define BASE_COLORS		256		        //J[pbg{
        #define BASE_PAT_SIZE	16		        //p^[TCY{
        #define TSTYLE_MAX		10		        //C퐔
        #define	DUMMY_TCODE		(jTC)(0x2121)	//_~[TRON CODE(JPN)
        #define SYS_PAT			1000		    //VXep^[idJnԍ
        #define fude_chsz 		(16)		    //̕WTCY
        #define LINE_MASK_SIZE	(8)		        //}XNTCY
        #define DEV_NAME_SIZE	(11)		    //foCX
        #define ARROW_LENGTH	(double)(12)	//n̒
        #define ARROW_ANGLE		(double)( M_PI / (double)6 )	//WA 30x
        #define A_ZONE			(1)
        #define B_ZONE			(2)
        #define C_ZONE			(3)
        #define D_ZONE			(4)

        bool _create;						//H
        //display primitive property
        TCanvas 	*canvas;				//`gid
        long 		_rop;					//`惂[h
        jTC			dev_name[DEV_NAME_SIZE];	//foCX
        jBITMAP		dev_bitmap;				//foCXŗLrbg}bv
        jW			_pixmask;				//sNZ}XN
        jRECT		_frame;					//t[`
        jRECT		_vis;					//\`
        jRLP		_fore;					//Ou`i΍Wj
        Clip		_clip;					//NbvǗ
        //`惏[N
        POINT _line_polygon[6];				//p`hׂp`W
        int _line_polygon_num;              //p`_
        //J[pbg
        RGBQUAD	_palette[ BASE_COLORS ];	//pbg
        bool _transparent[ BASE_COLORS ];	//F
        //p^[Ǘ
        TImageList	*_patterns;				//p^[ǗXg
        jPATTERN	_ipattern;				//p^[[Ni`j
        jPAT		_ipat;                  //p^[[NiC[Wj
        //`
        Graphics::TBitmap	*_src_char;		//`挴^
        Graphics::TBitmap	*_dst_char;		//`kg
        TImageList	*_characters;			//`C[Wobt@iOΉj
        int		_char_index;			    //LCfbNX
        jTC		last_fude;				    //ԍŌɕ`悵
        jPNT		fude;					//`ʒu
        jH		fude_dir;				    //`
        jCOLORVAL	fude_fgc;				//OiF
        jCOLORVAL	fude_bgc;				//wiF
        TColor		fude_tfc;				//OiFiJ[j
        TColor		fude_tbc;               //wiFiJ[j
        jCHGAP		fude_gap;				//Ԋu

        jFONTSPEC	fude_spec;				//tHgdl
        jFONTINF	fude_inf;				//tHg
        TFont*		fude_font;
        TFont*      hojo_font;              //⏕tHg
        //wiΉj
        jTC		_lang;                      //w

        jH      	lmk_nbytes;				//}XNoCg(P`Wj
        jUB		lmk_mask[ LINE_MASK_SIZE ];			//}XNp^[
        double		COS_ARROW_ANGLE;		//cos(30)
        double		SIN_ARROW_ANGLE;		//sin(30)
        Graphics::TBitmap	*_point_bmp;	//gdra_pnt̍Ɨ̈(1x1)
        //KtHgiɃoOHj@f[^`掞AsG[
        //ver.8.63܂RgB
        //GrayScaleFont gray_font;

        //private methods
        void create( jPARAM *param );
        void destroy(void);
        void __fastcall clr_ipat( jPAT *pat, TColor c );

        void __fastcall create_colors(void);
        void set_cos_sin_arrow(void);
        void __fastcall init_dp(void);
        jW _set_l_atr( jLATTR attr, jH &width );
        jERR __fastcall _gcre_spat( jPATTERN *def, jPAT *loc, jPAT **pat, jW *size );
        jERR __fastcall _gcre_mpat( jPATTERN *def, jPAT *loc, jPAT **pat, jW *size );
        jERR __fastcall _gdra_lin( jPNT p1, jPNT p2, jLATTR attr, jPATTERN *pat, jDCM mode );
        jERR __fastcall _gdra_arr( jPNT start, jPNT end, jLATTR attr, jPATP pat, jDCM mode );
        TColor __fastcall _colorval_tcolor( jCOLORVAL *cv );
        jCOLORVAL __fastcall _tcolor_colorval( TColor *tc );

        bool __fastcall get_vrcross( jRECT frame, jRECT *r );
        void __fastcall get_tile_covering( jRECT cr, jRECT *cv );
        void __fastcall tiling( jRECT frame, jUH attr, jPAT *ipat );
        void __fastcall init_gdev(void);
        void __fastcall init_gchstr(void);
        void __fastcall init_tstyle(void);
        void __fastcall init_tfont(void);
        void __fastcall init_truler(void);
        bool __fastcall judge_TRONzone( jTC* ch, int *zone );
        //int __fastcall mkSeqT(jTC lang,jTC tc);
        int __fastcall gtSeqT(jTC lang,jTC tc);
        void __fastcall drawTC( jTC tc,const int &x, const int &y, const int &width, const int &height, const TColor &fcol, const TColor &bcol, const jUH &fattr );
        void __fastcall drawTCsys( jTC tc,const int &x, const int &y, const int &width, const int &height, const TColor &fcol, const TColor &bcol, const jUH &fattr );
        //void __fastcall drawTCmk1( jTC tc,const int &x, const int &y, const int &width, const int &height, const TColor &fcol, const TColor &bcol, const jUH &fattr );
        //void __fastcall drawTCmk2( jTC tc,const int &x, const int &y, const int &width, const int &height, const TColor &fcol, const TColor &bcol, const jUH &fattr );
        //void __fastcall drawTCmk3( jTC tc,const int &x, const int &y, const int &width, const int &height, const TColor &fcol, const TColor &bcol, const jUH &fattr );
        void __fastcall drawTCgt( jTC tc,const int &x, const int &y, const int &width, const int &height, const TColor &fcol, const TColor &bcol, const jUH &fattr );
        void __fastcall drawTCimode( jTC tc,const int &x, const int &y, const int &width, const int &height, const TColor &fcol, const TColor &bcol, const jUH &fattr );
        void __fastcall drawTChot( jTC tc,const int &x, const int &y, const int &width, const int &height, const TColor &fcol, const TColor &bcol, const jUH &fattr );
    protected:
        jERR __fastcall gopn_dev( jTP dev, jPARAM *param );
        void __fastcall GID( jGID cv );
        void __fastcall set_nextchp( jTC ch );
    public:
        DisplayPrimitive();
        DisplayPrimitive( jPARAM *param );
        ~DisplayPrimitive();
        bool Check(void) { return _create; }
        TCanvas* Canvas() { return canvas; }

        jERR __fastcall gcls_env(void);
        jERR __fastcall gget_dev( jTP dev );

        jERR __fastcall gini_env(void);
        jERR __fastcall gget_spc( jTP dev, jDEV_SPEC *buf );
        jERR __fastcall gset_lmk( jH nbytes, jUB *mask );
        jERR __fastcall gget_lmk( jUB *mask );
        jERR __fastcall gset_msk( jW pixmask );
        jERR __fastcall gget_msk( jWP pixmask );
        jERR __fastcall gset_fra( jRECT r );
        jERR __fastcall gget_fra( jRP r );
        jERR __fastcall gset_vis( jRECT r );
        jERR __fastcall gget_vis( jRP r );
        jERR __fastcall gset_for( jRLP rlp );
        jERR __fastcall gget_for( jRLP rlp );
        jERR __fastcall gget_bnd( jRP rp );
        jERR __fastcall gmov_bnd( jH dh, jH dv );
        jERR __fastcall gmov_cor( jH dh, jH dv );
        jERR __fastcall gcnv_abs( jPP pp );
        jERR __fastcall gcnv_rel( jPP pp );

        jERR __fastcall gset_col( jH p, jCOLORVAL *cv, jH cnt );
        jERR __fastcall gget_col( jH p, jCOLORVAL *cv, jH cnt );
        jERR __fastcall gcnv_col( jCOLORVAL cv, jW *pixv );
        jERR __fastcall gsiz_pat( jH kind, jH hsize, jH vsize, jW *size );
        jERR __fastcall gcre_pat( jPATTERN *def, jPAT *loc, jPAT **pat, jW *size );

        jERR __fastcall gtst_pnt( jPNT p, jPIXVAL* val );
        jERR __fastcall gdra_pnt( jPNT p, jPIXVAL val, jDCM mode );
        jERR __fastcall gfil_pnt( jPNT p, jPATTERN *pat, jDCM mode );
        jERR __fastcall gdra_lin( jPNT p1, jPNT p2, jLATTR attr, jPATTERN *pat, jDCM mode );
        jERR __fastcall gfra_rec( jRECT r, jLATTR attr, jPATTERN *pat, jDEG angle, jDCM mode );
        jERR __fastcall gfil_rec( jRECT r, jPATTERN *pat, jDEG angle, jDCM mode );
        jERR __fastcall gfra_rrc( jRECT r, jH rh, jH rv, jLATTR attr, jPATTERN *pat, jDEG angle, jDCM mode );
        jERR __fastcall gfil_rrc( jRECT r, jH rh, jH rv, jPATTERN *pat, jDEG angle, jDCM mode );
        jERR __fastcall gfra_ovl( jRECT r, jLATTR attr, jPATTERN *pat, jDEG angle, jDCM mode );
        jERR __fastcall gfil_ovl( jRECT r, jPATTERN *pat, jDEG angle, jDCM mode );
        jERR __fastcall gdra_arc( jRECT r, jPNT sp, jPNT ep, jLATTR attr, jPATTERN *pat, jDEG angle, jDCM mode );
        jERR __fastcall gfra_sec( jRECT r, jPNT sp, jPNT ep, jLATTR attr, jPATTERN *pat, jDEG angle, jDCM mode );
        jERR __fastcall gfil_sec( jRECT r, jPNT sp, jPNT ep, jPATTERN *pat, jDEG angle, jDCM mode );
        jERR __fastcall gfra_cho( jRECT r, jPNT sp, jPNT ep, jLATTR attr, jPATTERN *pat, jDEG angle, jDCM mode );
        jERR __fastcall gfil_cho( jRECT r, jPNT sp, jPNT ep, jPATTERN *pat, jDEG angle, jDCM mode );
        jERR __fastcall gdra_pln( jPOLY *p, jLATTR attr, jPATTERN *pat, jDCM mode );
        jERR __fastcall gfra_pol( jPOLY *p, jLATTR attr, jPATTERN *pat, jDCM mode );
        jERR __fastcall gfil_pol( jPOLY *p, jPATTERN *pat, jDCM mode );
        jERR __fastcall gdra_spl( jH np, jPNT *pt, jLATTR attr, jPATTERN *pat, jDCM mode );
        jERR __fastcall gset_chp( jH h, jH v, jH abs );
        jERR __fastcall gget_chp( jH *h, jH *v );
        jERR __fastcall gset_chc( jCOLORVAL chfgc, jCOLORVAL chbgc );
        jERR __fastcall gget_chc( jCOLORVAL *chfgc, jCOLORVAL *chbgc );
        jERR __fastcall gset_chd( jH dir, jCHGAP *gap );
        jERR __fastcall gget_chd( jCHGAP *gap );
        jERR __fastcall gget_chw( jTC ch );
        jERR __fastcall gget_chh( jTC ch );
        jERR __fastcall gdra_chr( jTC ch, jDCM mode );
        jERR __fastcall gdra_chp( jH h, jH v, jTC ch, jDCM mode );
        jERR __fastcall gdra_str( jTC *str, jH len, jDCM mode );
        jERR __fastcall gdra_stp( jH h, jH v, jTC* str, jH len, jDCM mode );
        jERR __fastcall gset_fnt( jFONTSPEC *fnt );
        jERR __fastcall gget_fnt( jFONTSPEC *fnt, jFONTINF *inf );
        jERR __fastcall grst_bmp( jRP gr, jBMP bmap, jRP br, jGSCAN *mask, jDCM mode );
        jERR __fastcall gsav_bmp( jRP gr, jBMP bmap, jRP br, jGSCAN *mask, jDCM mode );

        //lib
        jH   __fastcall get_gappixel( jH ch, jH gap );
        jTC	__fastcall last_TC(void) { return last_fude; }
		jERR __fastcall gdra_arr( jUH arrow, jPNT start, jPNT end, jLATTR attr, jPATP pat, jDCM mode );
		jERR __fastcall gcre_msk( jBMP bmp, jGSCAN **mask );
        jERR __fastcall grel_msk( jGSCAN **mask );
        jERR __fastcall gset_lng( jTC lang );
        jERR __fastcall gget_lng( jTC *lang );
        jH pat_size_x();
        jH pat_size_y();
        void __fastcall setHojokanji(TFont *hojo);

};
#endif
#pragma nopackwarning

