//---------------------------------------------------------------------------
//
//	  y TAD viewer for Windows z
//    Display Primitive library
//	  JJ,micropower,HigashiHiroshima City,1997
//
//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#include "dpclass.h"
#pragma nopackwarning
//---------------------------------------------------------------------------
// RXgN^
//---------------------------------------------------------------------------
DisplayPrimitive::DisplayPrimitive()
{
	_create=true;
	create( NULL );
}
//---------------------------------------------------------------------------
// RXgN^
//---------------------------------------------------------------------------
DisplayPrimitive::DisplayPrimitive( jPARAM *param )
{
	_create=true;
	create( param );
}
//---------------------------------------------------------------------------
// Jn
//---------------------------------------------------------------------------
void DisplayPrimitive::create( jPARAM *param )
{
    setHojokanji(param->hojokanji);
    _create=( gopn_dev( (jTP)DEV, (jPARAM *)param ) >= 0 );
}
//---------------------------------------------------------------------------
//display primitiveϐ
//---------------------------------------------------------------------------
void __fastcall DisplayPrimitive::init_dp(void)
{
    init_gchstr();
    init_gdev();
}
//---------------------------------------------------------------------------
//  n
//---------------------------------------------------------------------------
void DisplayPrimitive::destroy(void)
{
	if( !_create )
    	return;
    init_dp();
    gcls_env();
    _create=false;
}
//---------------------------------------------------------------------------
// fXgN^
//---------------------------------------------------------------------------
DisplayPrimitive::~DisplayPrimitive()
{
	destroy();
}
//---------------------------------------------------------------------------
// `̐؂ւZbg
//---------------------------------------------------------------------------
void __fastcall DisplayPrimitive::GID( jGID cv )
{
	canvas=cv;
    if( canvas == NULL )
    	_create=false;
}
//---------------------------------------------------------------------------
// API: gget_spc Get Device Specification
// foCX̎o
//---------------------------------------------------------------------------
jERR __fastcall DisplayPrimitive::gget_spc( jTP dev, jDEV_SPEC *buf )
{
	CHECK_GID;
	if( buf == NULL )
    	return jEG_ADR;
    if( strcmp( (char *)dev, (char *)DEV ) != 0 )
    	return jEG_NOEXS;
	buf->planes=(jH)GetDeviceCaps( canvas->Handle, PLANES );
    //Erbg^Lrbg
    buf->pixbits=(jH)( (jH)(GetDeviceCaps( canvas->Handle, BITSPIXEL ) < 8 ) | (jH)0x0008 );
    buf->hpixels=buf->vpixels=(jH)0;
    buf->hres=(jH)GetDeviceCaps( canvas->Handle, HORZRES );
    buf->vres=(jH)GetDeviceCaps( canvas->Handle, VERTRES );
    buf->resv[0]=buf->resv[1]=buf->resv[2]=buf->resv[3]=buf->resv[4]=buf->resv[5]=(jH)0;
    return jEG_OK;
}
//---------------------------------------------------------------------------
void __fastcall DisplayPrimitive::init_gdev(void)
{
	dev_bitmap.planes=1;
    dev_bitmap.pixbits=0x0808;
    dev_bitmap.bounds.c.left=0;
    dev_bitmap.bounds.c.top=0;
    if( canvas != NULL )
    {
    	dev_bitmap.bounds.c.right=(jH)GetDeviceCaps( canvas->Handle, HORZRES );
    	dev_bitmap.bounds.c.bottom=(jH)GetDeviceCaps( canvas->Handle, VERTRES );
    }
    else
    {
    	dev_bitmap.bounds.c.right=(jH)640;
        dev_bitmap.bounds.c.bottom=(jH)480;
    }
    dev_bitmap.rowbytes=(jH)(((dev_bitmap.bounds.c.right + (jH)2 ) / (jH)2 ) * (jH)2);
    dev_bitmap.baseaddr[0]=NULL;
    _frame=dev_bitmap.bounds;
    _vis=dev_bitmap.bounds;
    _fore=NULL;
    _rop=SRCCOPY;
}
//---------------------------------------------------------------------------
// API `̏ Initialize Drawing Environment
//---------------------------------------------------------------------------
jERR __fastcall DisplayPrimitive::gini_env(void)
{
	CHECK_GID;
    if( _patterns == NULL )
    	return jEG_PAR;
    else
    	_patterns->Clear();
    if( _characters == NULL )
    	return jEG_PAR;
    else
    	_characters->Clear();
    //if( fude_font == NULL )
    //	return jEG_PAR;
    init_dp();
    _clip.make( dev_bitmap.bounds.p.lefttop, _frame, _vis, _fore );
    //p^[`惏[N
    _ipat.index=0;
    _ipat.bmp=new Graphics::TBitmap;
    if( _ipat.bmp == NULL )
    	return jEG_PAR;
    _ipattern.ipat.kind=2;
    _ipattern.ipat.hsize=(jH)BASE_PAT_SIZE;
    _ipattern.ipat.vsize=(jH)BASE_PAT_SIZE;
    _ipattern.ipat.pat=(jUB *)&_ipat;
    _ipat.bmp->Width=(int)BASE_PAT_SIZE;
    _ipat.bmp->Height=(int)BASE_PAT_SIZE;
    _patterns->Width=(int)BASE_PAT_SIZE;
    _patterns->Height=(int)BASE_PAT_SIZE;
    //`惏[N
    _src_char=new Graphics::TBitmap;
    if( _src_char == NULL )
    	return jEG_PAR;
    _src_char->Width=(int)fude_chsz;
    _src_char->Height=(int)fude_chsz;
    _dst_char=new Graphics::TBitmap;
    if( _dst_char == NULL )
    	return jEG_PAR;
    _dst_char->Width=(int)fude_chsz;
    _dst_char->Height=(int)fude_chsz;
    _characters->Width=(int)fude_chsz;
    _characters->Height=(int)fude_chsz;
    //̑
    create_colors();
    set_cos_sin_arrow();
    return jEG_OK ;
}
//---------------------------------------------------------------------------
// API foCX`̐ Open Device Drawing Environment
// iCv^ˑƎFA߂l̐ljEG_OKgidł͂ȂBj
//---------------------------------------------------------------------------
jERR __fastcall DisplayPrimitive::gopn_dev( jTP dev, jPARAM *param )
{
    if( dev == NULL )
    	dev_name[0]=jTNULL;
    else
        strncpy( (char *)dev_name, (char *)dev, (size_t)( sizeof(jTC) * DEV_NAME_SIZE ) );
    if( strcmp( (char *)dev, (char *)DEV ) != 0 )
    	return jEG_NOEXS;
    if( param == NULL )
    	return jEG_PAR;
    //p^[`ƋԂ̃Zbg
    _patterns=param->patImageList;
    _characters=param->charImageList;
    canvas=param->gid;
    fude_font=param->screenFont;
    //gdra_pnt_`Ɨ̈m
	_point_bmp=new Graphics::TBitmap;
    if( _point_bmp != NULL )
    {
    	_point_bmp->Width=1;
        _point_bmp->Height=1;
    }
    return gini_env();
}
//---------------------------------------------------------------------------
// API `̍폜 close Drawing Environment
//---------------------------------------------------------------------------
jERR __fastcall DisplayPrimitive::gcls_env(void)
{
	CHECK_GID;
	dev_name[0]=jTNULL;
    if( _ipat.bmp != NULL )
    {
		delete _ipat.bmp;
        _ipat.bmp=NULL;
    }
    if( _src_char != NULL )
    {
    	delete _src_char;
        _src_char=NULL;
    }
    if( _dst_char != NULL )
    {
    	delete _dst_char;
        _dst_char=NULL;
    }
    if( _point_bmp != NULL )
    {
    	delete _point_bmp;
        _point_bmp=NULL;
    }
    canvas=NULL;
    return jEG_OK;
}
//---------------------------------------------------------------------------
//API: gget_dev Get Device Name
//ΏۃfoCX̎o
//---------------------------------------------------------------------------
jERR __fastcall DisplayPrimitive::gget_dev(jTP dev)
{
	if( dev == NULL )
    	return jEG_ADR;
    strcpy( (char *)DEV, (char *)dev );
    return 0;	//܂foCX`̂
}
//---------------------------------------------------------------------------
// API: gset_lmk Set Line Mask
// }XNp^[̐ݒ
//---------------------------------------------------------------------------
jERR __fastcall DisplayPrimitive::gset_lmk( jH nbytes, jUB *mask )
{
	CHECK_GID;
	if( nbytes < 1 || nbytes > LINE_MASK_SIZE )
    	return jEG_PAR;
    if( mask == NULL )
    	return jEG_ADR;
    lmk_nbytes=min( nbytes, (jH)LINE_MASK_SIZE );
    memcpy( lmk_mask, mask, (size_t)lmk_nbytes );
    return jEG_OK;
}
//---------------------------------------------------------------------------
//API: gget_lmk Get Line Mask
//}XNp^[̎o
//---------------------------------------------------------------------------
jERR __fastcall DisplayPrimitive::gget_lmk( jUB *mask )
{
	CHECK_GID;
	if( mask == NULL )
    	return jEG_ADR;
    memcpy( mask, lmk_mask, (size_t)lmk_nbytes );
    return (jERR)lmk_nbytes;
}
//---------------------------------------------------------------------------
//API: gset_mak Set Drawing Pixel Mask
//`sNZ}XN̐ݒ
//---------------------------------------------------------------------------
jERR __fastcall DisplayPrimitive::gset_msk( jW pixmask )
{
	CHECK_GID;
	_pixmask=pixmask;
    return jEG_OK;
}
//---------------------------------------------------------------------------
//API: gget_mak Get Drawing Pixel Mask
//`sNZ}XN̎o
//---------------------------------------------------------------------------
jERR __fastcall DisplayPrimitive::gget_msk( jWP pixmask )
{
	CHECK_GID;
	if( pixmask == NULL )
    	return jEG_ADR;
	*pixmask=_pixmask;
    return jEG_OK;
}
//---------------------------------------------------------------------------
//API: gset_fra Set Frame Rectangle
//t[`̐ݒ
//---------------------------------------------------------------------------
jERR __fastcall DisplayPrimitive::gset_fra( jRECT r )
{
	CHECK_GID;
    CHECK_RECT;
	_frame=r;
    _clip.make( dev_bitmap.bounds.p.lefttop, _frame, _vis, _fore );
    return jEG_OK;
}
//---------------------------------------------------------------------------
//API: gget_fra Get Frame Rectangle
//t[`̎o
//---------------------------------------------------------------------------
jERR __fastcall DisplayPrimitive::gget_fra( jRP r )
{
	CHECK_GID;
	*r=_frame;
    return jEG_OK;
}
//---------------------------------------------------------------------------
//API: gset_vis Set Visible Rectangle
//\`̐ݒ
//---------------------------------------------------------------------------
jERR __fastcall DisplayPrimitive::gset_vis( jRECT r )
{
	CHECK_GID;
    CHECK_RECT;
	_vis=r;
    _clip.make( dev_bitmap.bounds.p.lefttop, _frame, _vis, _fore );
    _clip.set_clip( canvas );
    return jEG_OK;
}
//---------------------------------------------------------------------------
//API: gget_vis Get Visible Rectangle
//\`̎o
//---------------------------------------------------------------------------
jERR __fastcall DisplayPrimitive::gget_vis( jRP r )
{
	CHECK_GID;
	*r=_vis;
    return jEG_OK;
}
//---------------------------------------------------------------------------
//API: gset_for Set Foreground Rectangle List
//Ou`Xg̐ݒ
//---------------------------------------------------------------------------
jERR __fastcall DisplayPrimitive::gset_for( jRLP rlp )
{
	CHECK_GID;
	_fore=rlp;
    if( !empty_rect( rlp->rcomp ) )
    	return jEG_PAR;
    _clip.make( dev_bitmap.bounds.p.lefttop, _frame, _vis, _fore );
    return jEG_OK;
}
//---------------------------------------------------------------------------
//API: gget_for Get Foreground Rectangle List
//Ou`Xg̎o
// rlpɑOu`̃Xgi[Bi炩rlpɃXgZbg邱Ɓj
// rlp:NULL̏ꍇAOu`̑̂ݕԂB
// ߂lFOu`̑ԂB
//---------------------------------------------------------------------------
jERR __fastcall DisplayPrimitive::gget_for( jRLP rlp )
{
	CHECK_GID;
	jRLP src,dst;
    int count=0;
    src=_fore;
    dst=rlp;
    if( src != NULL )
    {
		for( ; ; )
    	{
        	//S
        	if( count >= (int)0x7FFF )
            	break;
        	count++;
            if( dst != NULL )
            	dst->rcomp=src->rcomp;
    		if( src->r_next == NULL )
        		break;
            //̒`
            if( src != NULL )
            	src=src->r_next;
            if( dst != NULL )
            	dst=dst->r_next;
    	} //for
    }
    return (jERR)count;
}
//---------------------------------------------------------------------------
//API: gget_bnd Get Bitmap Bounds
//rbg}bvE̎o
//---------------------------------------------------------------------------
jERR __fastcall DisplayPrimitive::gget_bnd( jRP rp )
{
	CHECK_GID;
	if( rp == NULL )
    	return jEG_ADR;
    *rp=dev_bitmap.bounds;
    return jEG_OK;
}
//---------------------------------------------------------------------------
// src`dh,dvقǈړAdstɊi[
//---------------------------------------------------------------------------
jERR check_movr( jRECT src, jRECT &dst, jH dh, jH dv )
{
    jW left=(jW)( src.c.left + dh );
    jW right=(jW)( src.c.right + dh );
    jW top=(jW)( src.c.top + dv );
    jW bottom=(jW)( src.c.bottom + dv );
    if( left < (int)DP_MIN || left > (int)DP_MAX )
    	return jEG_PAR;
    if( right < (int)DP_MIN || right > (int)DP_MAX )
    	return jEG_PAR;
    if( top < (int)DP_MIN || top > (int)DP_MAX )
    	return jEG_PAR;
    if( bottom < (int)DP_MIN || bottom > (int)DP_MAX )
    	return jEG_PAR;
    dst.c.left=(jH)left;
    dst.c.right=(jH)right;
    dst.c.top=(jH)top;
    dst.c.bottom=(jH)bottom;
    return jEG_OK;
}
//---------------------------------------------------------------------------
// src_dh,dvقǈړAdstɊi[B
//---------------------------------------------------------------------------
jERR check_movp( jPNT src, jPNT &dst, jH dh, jH dv )
{
    jW h=(jW)( src.x + dh );
    jW v=(jW)( src.y + dv );
    if( h < (int)DP_MIN || h > (int)DP_MAX )
    	return jEG_PAR;
    if( v < (int)DP_MIN || v > (int)DP_MAX )
    	return jEG_PAR;
    dst.x=(jH)h;
    dst.y=(jH)v;
    return jEG_OK;
}
//---------------------------------------------------------------------------
//API: gmov_bnd Move Bitmap Bounds
//rbg}bvËړ
//---------------------------------------------------------------------------
jERR __fastcall DisplayPrimitive::gmov_bnd( jH dh, jH dv )
{
	CHECK_GID;
	jRECT r;
    jERR result=check_movr( dev_bitmap.bounds, r, dh, dv );
    if( result >= 0 )
    	dev_bitmap.bounds=r;
    //蒼
    _clip.make( dev_bitmap.bounds.p.lefttop, _frame, _vis, _fore );
    return result;
}
//---------------------------------------------------------------------------
// sub API: gmov_cor Move Coordination
//Wn̈ړ
//---------------------------------------------------------------------------
jERR __fastcall DisplayPrimitive::gmov_cor( jH dh, jH dv )
{
	CHECK_GID;
	jRECT bounds;
    jERR result=check_movr( dev_bitmap.bounds, bounds, dh, dv );
    if( result < 0 )
    	return result;
    jRECT frame;
    result=check_movr( dev_bitmap.bounds, frame, dh, dv );
    if( result < 0 )
    	return result;
    jRECT vis;
    result=check_movr( dev_bitmap.bounds, vis, dh, dv );
    if( result < 0 )
    	return result;
    jPNT fpt;
    result=check_movp( fude, fpt, dh, dv );
    if( result < 0 )
    	return result;
    dev_bitmap.bounds=bounds;
    _frame=frame;
    _vis=vis;
    fude=fpt;
    //蒼
    _clip.make( dev_bitmap.bounds.p.lefttop, _frame, _vis, _fore );
    return result;
}
//---------------------------------------------------------------------------
// _ppWbp(bounds.p.lefttop)ő΍Wɕϊ iʂppɊi[j
//---------------------------------------------------------------------------
jERR _gcnv_rel( jPNT bp, jPP pp )
{
	if( pp == NULL )
    	return jEG_ADR;
    jPNT src,dst;
    src=*pp;
    jERR result=check_movp( src, dst, bp.x, bp.y );
    if( result < 0 )
    	return result;
    *pp=dst;
    return jEG_OK;
}
//---------------------------------------------------------------------------
// _ppWbp(bounds.p.lefttop) Ő΍WɕϊiʂppɊi[j
//---------------------------------------------------------------------------
jERR _gcnv_abs( jPNT bp, jPP pp )
{
	bp.x = (jH)( (jH)-1 *  bp.x );
    bp.y = (jH)( (jH)-1 * bp.y );
	return _gcnv_rel( bp, pp );
}
//---------------------------------------------------------------------------
// API: gcnv_abs Convert to Absolute Coordination
//΍Wւ̕ϊi΍Wpp΍WɕϊAʂppɊi[j
//---------------------------------------------------------------------------
jERR __fastcall DisplayPrimitive::gcnv_abs( jPP pp )
{
	CHECK_GID;
	return _gcnv_abs( dev_bitmap.bounds.p.lefttop, pp );
}
//---------------------------------------------------------------------------
// API: gcnv_rel Convert to Relative Coordination
//΍Wւ̕ϊi΍Wpp𑊑΍WɕϊAʂppɊi[j
//---------------------------------------------------------------------------
jERR __fastcall DisplayPrimitive::gcnv_rel( jPP pp )
{
	CHECK_GID;
	return _gcnv_rel( dev_bitmap.bounds.p.lefttop, pp );
}
//---------------------------------------------------------------------------
// ⏕tHgZbgB
//---------------------------------------------------------------------------
void __fastcall DisplayPrimitive::setHojokanji(TFont* hojo)
{
    hojo_font=hojo;
}

